<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoomGuest ArrayType
 * @subpackage Arrays
 */
class ArrayOfRoomGuest extends AbstractStructArrayBase
{
    /**
     * The RoomGuest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RoomGuest[]
     */
    public $RoomGuest;
    /**
     * Constructor method for ArrayOfRoomGuest
     * @uses ArrayOfRoomGuest::setRoomGuest()
     * @param \StructType\RoomGuest[] $roomGuest
     */
    public function __construct(array $roomGuest = array())
    {
        $this
            ->setRoomGuest($roomGuest);
    }
    /**
     * Get RoomGuest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RoomGuest[]|null
     */
    public function getRoomGuest()
    {
        return isset($this->RoomGuest) ? $this->RoomGuest : null;
    }
    /**
     * Set RoomGuest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RoomGuest[] $roomGuest
     * @return \ArrayType\ArrayOfRoomGuest
     */
    public function setRoomGuest(array $roomGuest = array())
    {
        foreach ($roomGuest as $arrayOfRoomGuestRoomGuestItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoomGuestRoomGuestItem instanceof \StructType\RoomGuest) {
                throw new \InvalidArgumentException(sprintf('The RoomGuest property can only contain items of \StructType\RoomGuest, "%s" given', is_object($arrayOfRoomGuestRoomGuestItem) ? get_class($arrayOfRoomGuestRoomGuestItem) : gettype($arrayOfRoomGuestRoomGuestItem)), __LINE__);
            }
        }
        if (is_null($roomGuest) || (is_array($roomGuest) && empty($roomGuest))) {
            unset($this->RoomGuest);
        } else {
            $this->RoomGuest = $roomGuest;
        }
        return $this;
    }
    /**
     * Add item to RoomGuest value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomGuest $item
     * @return \ArrayType\ArrayOfRoomGuest
     */
    public function addToRoomGuest(\StructType\RoomGuest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomGuest) {
            throw new \InvalidArgumentException(sprintf('The RoomGuest property can only contain items of \StructType\RoomGuest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomGuest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RoomGuest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RoomGuest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RoomGuest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RoomGuest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RoomGuest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoomGuest
     */
    public function getAttributeName()
    {
        return 'RoomGuest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRoomGuest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
