<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfHotel_Room ArrayType
 * @subpackage Arrays
 */
class ArrayOfHotel_Room extends AbstractStructArrayBase
{
    /**
     * The HotelRoom
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Hotel_Room[]
     */
    public $HotelRoom;
    /**
     * Constructor method for ArrayOfHotel_Room
     * @uses ArrayOfHotel_Room::setHotelRoom()
     * @param \StructType\Hotel_Room[] $hotelRoom
     */
    public function __construct(array $hotelRoom = array())
    {
        $this
            ->setHotelRoom($hotelRoom);
    }
    /**
     * Get HotelRoom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Hotel_Room[]|null
     */
    public function getHotelRoom()
    {
        return isset($this->HotelRoom) ? $this->HotelRoom : null;
    }
    /**
     * Set HotelRoom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel_Room[] $hotelRoom
     * @return \ArrayType\ArrayOfHotel_Room
     */
    public function setHotelRoom(array $hotelRoom = array())
    {
        foreach ($hotelRoom as $arrayOfHotel_RoomHotelRoomItem) {
            // validation for constraint: itemType
            if (!$arrayOfHotel_RoomHotelRoomItem instanceof \StructType\Hotel_Room) {
                throw new \InvalidArgumentException(sprintf('The HotelRoom property can only contain items of \StructType\Hotel_Room, "%s" given', is_object($arrayOfHotel_RoomHotelRoomItem) ? get_class($arrayOfHotel_RoomHotelRoomItem) : gettype($arrayOfHotel_RoomHotelRoomItem)), __LINE__);
            }
        }
        if (is_null($hotelRoom) || (is_array($hotelRoom) && empty($hotelRoom))) {
            unset($this->HotelRoom);
        } else {
            $this->HotelRoom = $hotelRoom;
        }
        return $this;
    }
    /**
     * Add item to HotelRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel_Room $item
     * @return \ArrayType\ArrayOfHotel_Room
     */
    public function addToHotelRoom(\StructType\Hotel_Room $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hotel_Room) {
            throw new \InvalidArgumentException(sprintf('The HotelRoom property can only contain items of \StructType\Hotel_Room, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelRoom[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Hotel_Room|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Hotel_Room|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Hotel_Room|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Hotel_Room|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Hotel_Room|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HotelRoom
     */
    public function getAttributeName()
    {
        return 'HotelRoom';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfHotel_Room
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
