<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfHotel_Result ArrayType
 * @subpackage Arrays
 */
class ArrayOfHotel_Result extends AbstractStructArrayBase
{
    /**
     * The HotelResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Hotel_Result[]
     */
    public $HotelResult;
    /**
     * Constructor method for ArrayOfHotel_Result
     * @uses ArrayOfHotel_Result::setHotelResult()
     * @param \StructType\Hotel_Result[] $hotelResult
     */
    public function __construct(array $hotelResult = array())
    {
        $this
            ->setHotelResult($hotelResult);
    }
    /**
     * Get HotelResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Hotel_Result[]|null
     */
    public function getHotelResult()
    {
        return isset($this->HotelResult) ? $this->HotelResult : null;
    }
    /**
     * Set HotelResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel_Result[] $hotelResult
     * @return \ArrayType\ArrayOfHotel_Result
     */
    public function setHotelResult(array $hotelResult = array())
    {
        foreach ($hotelResult as $arrayOfHotel_ResultHotelResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfHotel_ResultHotelResultItem instanceof \StructType\Hotel_Result) {
                throw new \InvalidArgumentException(sprintf('The HotelResult property can only contain items of \StructType\Hotel_Result, "%s" given', is_object($arrayOfHotel_ResultHotelResultItem) ? get_class($arrayOfHotel_ResultHotelResultItem) : gettype($arrayOfHotel_ResultHotelResultItem)), __LINE__);
            }
        }
        if (is_null($hotelResult) || (is_array($hotelResult) && empty($hotelResult))) {
            unset($this->HotelResult);
        } else {
            $this->HotelResult = $hotelResult;
        }
        return $this;
    }
    /**
     * Add item to HotelResult value
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel_Result $item
     * @return \ArrayType\ArrayOfHotel_Result
     */
    public function addToHotelResult(\StructType\Hotel_Result $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hotel_Result) {
            throw new \InvalidArgumentException(sprintf('The HotelResult property can only contain items of \StructType\Hotel_Result, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Hotel_Result|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Hotel_Result|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Hotel_Result|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Hotel_Result|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Hotel_Result|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HotelResult
     */
    public function getAttributeName()
    {
        return 'HotelResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfHotel_Result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
