<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCityList ArrayType
 * @subpackage Arrays
 */
class ArrayOfCityList extends AbstractStructArrayBase
{
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CityList[]
     */
    public $City;
    /**
     * Constructor method for ArrayOfCityList
     * @uses ArrayOfCityList::setCity()
     * @param \StructType\CityList[] $city
     */
    public function __construct(array $city = array())
    {
        $this
            ->setCity($city);
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CityList[]|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CityList[] $city
     * @return \ArrayType\ArrayOfCityList
     */
    public function setCity(array $city = array())
    {
        foreach ($city as $arrayOfCityListCityItem) {
            // validation for constraint: itemType
            if (!$arrayOfCityListCityItem instanceof \StructType\CityList) {
                throw new \InvalidArgumentException(sprintf('The City property can only contain items of \StructType\CityList, "%s" given', is_object($arrayOfCityListCityItem) ? get_class($arrayOfCityListCityItem) : gettype($arrayOfCityListCityItem)), __LINE__);
            }
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Add item to City value
     * @throws \InvalidArgumentException
     * @param \StructType\CityList $item
     * @return \ArrayType\ArrayOfCityList
     */
    public function addToCity(\StructType\CityList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CityList) {
            throw new \InvalidArgumentException(sprintf('The City property can only contain items of \StructType\CityList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->City[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CityList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CityList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CityList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CityList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CityList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string City
     */
    public function getAttributeName()
    {
        return 'City';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCityList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
