<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplement StructType
 * @subpackage Structs
 */
class Supplement extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The SuppID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $SuppID;
    /**
     * The SuppIsMandatory
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $SuppIsMandatory;
    /**
     * The SuppChargeType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SuppChargeType;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Price;
    /**
     * The SuppName
     * @var string
     */
    public $SuppName;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for Supplement
     * @uses Supplement::setType()
     * @uses Supplement::setSuppID()
     * @uses Supplement::setSuppIsMandatory()
     * @uses Supplement::setSuppChargeType()
     * @uses Supplement::setPrice()
     * @uses Supplement::setSuppName()
     * @uses Supplement::setCurrencyCode()
     * @param string $type
     * @param int $suppID
     * @param bool $suppIsMandatory
     * @param string $suppChargeType
     * @param float $price
     * @param string $suppName
     * @param string $currencyCode
     */
    public function __construct($type = null, $suppID = null, $suppIsMandatory = null, $suppChargeType = null, $price = null, $suppName = null, $currencyCode = null)
    {
        $this
            ->setType($type)
            ->setSuppID($suppID)
            ->setSuppIsMandatory($suppIsMandatory)
            ->setSuppChargeType($suppChargeType)
            ->setPrice($price)
            ->setSuppName($suppName)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\SupplementType::valueIsValid()
     * @uses \EnumType\SupplementType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Supplement
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SupplementType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\SupplementType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get SuppID value
     * @return int
     */
    public function getSuppID()
    {
        return $this->SuppID;
    }
    /**
     * Set SuppID value
     * @param int $suppID
     * @return \StructType\Supplement
     */
    public function setSuppID($suppID = null)
    {
        // validation for constraint: int
        if (!is_null($suppID) && !is_numeric($suppID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($suppID)), __LINE__);
        }
        $this->SuppID = $suppID;
        return $this;
    }
    /**
     * Get SuppIsMandatory value
     * @return bool
     */
    public function getSuppIsMandatory()
    {
        return $this->SuppIsMandatory;
    }
    /**
     * Set SuppIsMandatory value
     * @param bool $suppIsMandatory
     * @return \StructType\Supplement
     */
    public function setSuppIsMandatory($suppIsMandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($suppIsMandatory) && !is_bool($suppIsMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($suppIsMandatory)), __LINE__);
        }
        $this->SuppIsMandatory = $suppIsMandatory;
        return $this;
    }
    /**
     * Get SuppChargeType value
     * @return string
     */
    public function getSuppChargeType()
    {
        return $this->SuppChargeType;
    }
    /**
     * Set SuppChargeType value
     * @uses \EnumType\SupmtChargeType::valueIsValid()
     * @uses \EnumType\SupmtChargeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $suppChargeType
     * @return \StructType\Supplement
     */
    public function setSuppChargeType($suppChargeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SupmtChargeType::valueIsValid($suppChargeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $suppChargeType, implode(', ', \EnumType\SupmtChargeType::getValidValues())), __LINE__);
        }
        $this->SuppChargeType = $suppChargeType;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\Supplement
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get SuppName value
     * @return string|null
     */
    public function getSuppName()
    {
        return $this->SuppName;
    }
    /**
     * Set SuppName value
     * @param string $suppName
     * @return \StructType\Supplement
     */
    public function setSuppName($suppName = null)
    {
        // validation for constraint: string
        if (!is_null($suppName) && !is_string($suppName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suppName)), __LINE__);
        }
        $this->SuppName = $suppName;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\Supplement
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Supplement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
