<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supp_info StructType
 * @subpackage Structs
 */
class Supp_info extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The SuppChargeType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SuppChargeType;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Price;
    /**
     * The SuppName
     * @var string
     */
    public $SuppName;
    /**
     * Constructor method for Supp_info
     * @uses Supp_info::setType()
     * @uses Supp_info::setSuppChargeType()
     * @uses Supp_info::setPrice()
     * @uses Supp_info::setSuppName()
     * @param string $type
     * @param string $suppChargeType
     * @param float $price
     * @param string $suppName
     */
    public function __construct($type = null, $suppChargeType = null, $price = null, $suppName = null)
    {
        $this
            ->setType($type)
            ->setSuppChargeType($suppChargeType)
            ->setPrice($price)
            ->setSuppName($suppName);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\SupplementType::valueIsValid()
     * @uses \EnumType\SupplementType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Supp_info
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SupplementType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\SupplementType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get SuppChargeType value
     * @return string
     */
    public function getSuppChargeType()
    {
        return $this->SuppChargeType;
    }
    /**
     * Set SuppChargeType value
     * @uses \EnumType\SupmtChargeType::valueIsValid()
     * @uses \EnumType\SupmtChargeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $suppChargeType
     * @return \StructType\Supp_info
     */
    public function setSuppChargeType($suppChargeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SupmtChargeType::valueIsValid($suppChargeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $suppChargeType, implode(', ', \EnumType\SupmtChargeType::getValidValues())), __LINE__);
        }
        $this->SuppChargeType = $suppChargeType;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\Supp_info
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get SuppName value
     * @return string|null
     */
    public function getSuppName()
    {
        return $this->SuppName;
    }
    /**
     * Set SuppName value
     * @param string $suppName
     * @return \StructType\Supp_info
     */
    public function setSuppName($suppName = null)
    {
        // validation for constraint: string
        if (!is_null($suppName) && !is_string($suppName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suppName)), __LINE__);
        }
        $this->SuppName = $suppName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Supp_info
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
