<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRes StructType
 * @subpackage Structs
 */
class RoomRes extends AbstractStructBase
{
    /**
     * The Amended
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Amended;
    /**
     * The Guest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AmendGuestRes[]
     */
    public $Guest;
    /**
     * Constructor method for RoomRes
     * @uses RoomRes::setAmended()
     * @uses RoomRes::setGuest()
     * @param string $amended
     * @param \StructType\AmendGuestRes[] $guest
     */
    public function __construct($amended = null, array $guest = array())
    {
        $this
            ->setAmended($amended)
            ->setGuest($guest);
    }
    /**
     * Get Amended value
     * @return string
     */
    public function getAmended()
    {
        return $this->Amended;
    }
    /**
     * Set Amended value
     * @uses \EnumType\RoomRequested::valueIsValid()
     * @uses \EnumType\RoomRequested::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amended
     * @return \StructType\RoomRes
     */
    public function setAmended($amended = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoomRequested::valueIsValid($amended)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $amended, implode(', ', \EnumType\RoomRequested::getValidValues())), __LINE__);
        }
        $this->Amended = $amended;
        return $this;
    }
    /**
     * Get Guest value
     * @return \StructType\AmendGuestRes[]|null
     */
    public function getGuest()
    {
        return $this->Guest;
    }
    /**
     * Set Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\AmendGuestRes[] $guest
     * @return \StructType\RoomRes
     */
    public function setGuest(array $guest = array())
    {
        foreach ($guest as $roomResGuestItem) {
            // validation for constraint: itemType
            if (!$roomResGuestItem instanceof \StructType\AmendGuestRes) {
                throw new \InvalidArgumentException(sprintf('The Guest property can only contain items of \StructType\AmendGuestRes, "%s" given', is_object($roomResGuestItem) ? get_class($roomResGuestItem) : gettype($roomResGuestItem)), __LINE__);
            }
        }
        $this->Guest = $guest;
        return $this;
    }
    /**
     * Add item to Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\AmendGuestRes $item
     * @return \StructType\RoomRes
     */
    public function addToGuest(\StructType\AmendGuestRes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AmendGuestRes) {
            throw new \InvalidArgumentException(sprintf('The Guest property can only contain items of \StructType\AmendGuestRes, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Guest[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomRes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
