<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRate StructType
 * @subpackage Structs
 */
class RoomRate extends AbstractStructBase
{
    /**
     * The ExtraGuestCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ExtraGuestCharges;
    /**
     * The ChildCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChildCharges;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Discount;
    /**
     * The OtherCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OtherCharges;
    /**
     * The ServiceTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ServiceTax;
    /**
     * The IsPackageRate
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsPackageRate;
    /**
     * The B2CRates
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $B2CRates;
    /**
     * The AgentMarkUp
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $AgentMarkUp;
    /**
     * The RoomFare
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $RoomFare;
    /**
     * The RoomTax
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $RoomTax;
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $TotalFare;
    /**
     * The DayRates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDayRate
     */
    public $DayRates;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The PrefPrice
     * @var string
     */
    public $PrefPrice;
    /**
     * The HeadGSAMarkUp
     * @var string
     */
    public $HeadGSAMarkUp;
    /**
     * The PrefCurrency
     * @var string
     */
    public $PrefCurrency;
    /**
     * Constructor method for RoomRate
     * @uses RoomRate::setExtraGuestCharges()
     * @uses RoomRate::setChildCharges()
     * @uses RoomRate::setDiscount()
     * @uses RoomRate::setOtherCharges()
     * @uses RoomRate::setServiceTax()
     * @uses RoomRate::setIsPackageRate()
     * @uses RoomRate::setB2CRates()
     * @uses RoomRate::setAgentMarkUp()
     * @uses RoomRate::setRoomFare()
     * @uses RoomRate::setRoomTax()
     * @uses RoomRate::setTotalFare()
     * @uses RoomRate::setDayRates()
     * @uses RoomRate::setCurrency()
     * @uses RoomRate::setPrefPrice()
     * @uses RoomRate::setHeadGSAMarkUp()
     * @uses RoomRate::setPrefCurrency()
     * @param float $extraGuestCharges
     * @param float $childCharges
     * @param float $discount
     * @param float $otherCharges
     * @param float $serviceTax
     * @param bool $isPackageRate
     * @param bool $b2CRates
     * @param float $agentMarkUp
     * @param float $roomFare
     * @param float $roomTax
     * @param float $totalFare
     * @param \ArrayType\ArrayOfDayRate $dayRates
     * @param string $currency
     * @param string $prefPrice
     * @param string $headGSAMarkUp
     * @param string $prefCurrency
     */
    public function __construct($extraGuestCharges = null, $childCharges = null, $discount = null, $otherCharges = null, $serviceTax = null, $isPackageRate = null, $b2CRates = null, $agentMarkUp = null, $roomFare = null, $roomTax = null, $totalFare = null, \ArrayType\ArrayOfDayRate $dayRates = null, $currency = null, $prefPrice = null, $headGSAMarkUp = null, $prefCurrency = null)
    {
        $this
            ->setExtraGuestCharges($extraGuestCharges)
            ->setChildCharges($childCharges)
            ->setDiscount($discount)
            ->setOtherCharges($otherCharges)
            ->setServiceTax($serviceTax)
            ->setIsPackageRate($isPackageRate)
            ->setB2CRates($b2CRates)
            ->setAgentMarkUp($agentMarkUp)
            ->setRoomFare($roomFare)
            ->setRoomTax($roomTax)
            ->setTotalFare($totalFare)
            ->setDayRates($dayRates)
            ->setCurrency($currency)
            ->setPrefPrice($prefPrice)
            ->setHeadGSAMarkUp($headGSAMarkUp)
            ->setPrefCurrency($prefCurrency);
    }
    /**
     * Get ExtraGuestCharges value
     * @return float
     */
    public function getExtraGuestCharges()
    {
        return $this->ExtraGuestCharges;
    }
    /**
     * Set ExtraGuestCharges value
     * @param float $extraGuestCharges
     * @return \StructType\RoomRate
     */
    public function setExtraGuestCharges($extraGuestCharges = null)
    {
        $this->ExtraGuestCharges = $extraGuestCharges;
        return $this;
    }
    /**
     * Get ChildCharges value
     * @return float
     */
    public function getChildCharges()
    {
        return $this->ChildCharges;
    }
    /**
     * Set ChildCharges value
     * @param float $childCharges
     * @return \StructType\RoomRate
     */
    public function setChildCharges($childCharges = null)
    {
        $this->ChildCharges = $childCharges;
        return $this;
    }
    /**
     * Get Discount value
     * @return float
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \StructType\RoomRate
     */
    public function setDiscount($discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get OtherCharges value
     * @return float
     */
    public function getOtherCharges()
    {
        return $this->OtherCharges;
    }
    /**
     * Set OtherCharges value
     * @param float $otherCharges
     * @return \StructType\RoomRate
     */
    public function setOtherCharges($otherCharges = null)
    {
        $this->OtherCharges = $otherCharges;
        return $this;
    }
    /**
     * Get ServiceTax value
     * @return float
     */
    public function getServiceTax()
    {
        return $this->ServiceTax;
    }
    /**
     * Set ServiceTax value
     * @param float $serviceTax
     * @return \StructType\RoomRate
     */
    public function setServiceTax($serviceTax = null)
    {
        $this->ServiceTax = $serviceTax;
        return $this;
    }
    /**
     * Get IsPackageRate value
     * @return bool
     */
    public function getIsPackageRate()
    {
        return $this->IsPackageRate;
    }
    /**
     * Set IsPackageRate value
     * @param bool $isPackageRate
     * @return \StructType\RoomRate
     */
    public function setIsPackageRate($isPackageRate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPackageRate) && !is_bool($isPackageRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPackageRate)), __LINE__);
        }
        $this->IsPackageRate = $isPackageRate;
        return $this;
    }
    /**
     * Get B2CRates value
     * @return bool
     */
    public function getB2CRates()
    {
        return $this->B2CRates;
    }
    /**
     * Set B2CRates value
     * @param bool $b2CRates
     * @return \StructType\RoomRate
     */
    public function setB2CRates($b2CRates = null)
    {
        // validation for constraint: boolean
        if (!is_null($b2CRates) && !is_bool($b2CRates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($b2CRates)), __LINE__);
        }
        $this->B2CRates = $b2CRates;
        return $this;
    }
    /**
     * Get AgentMarkUp value
     * @return float
     */
    public function getAgentMarkUp()
    {
        return $this->AgentMarkUp;
    }
    /**
     * Set AgentMarkUp value
     * @param float $agentMarkUp
     * @return \StructType\RoomRate
     */
    public function setAgentMarkUp($agentMarkUp = null)
    {
        $this->AgentMarkUp = $agentMarkUp;
        return $this;
    }
    /**
     * Get RoomFare value
     * @return float
     */
    public function getRoomFare()
    {
        return $this->RoomFare;
    }
    /**
     * Set RoomFare value
     * @param float $roomFare
     * @return \StructType\RoomRate
     */
    public function setRoomFare($roomFare = null)
    {
        $this->RoomFare = $roomFare;
        return $this;
    }
    /**
     * Get RoomTax value
     * @return float
     */
    public function getRoomTax()
    {
        return $this->RoomTax;
    }
    /**
     * Set RoomTax value
     * @param float $roomTax
     * @return \StructType\RoomRate
     */
    public function setRoomTax($roomTax = null)
    {
        $this->RoomTax = $roomTax;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return float
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param float $totalFare
     * @return \StructType\RoomRate
     */
    public function setTotalFare($totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get DayRates value
     * @return \ArrayType\ArrayOfDayRate|null
     */
    public function getDayRates()
    {
        return $this->DayRates;
    }
    /**
     * Set DayRates value
     * @param \ArrayType\ArrayOfDayRate $dayRates
     * @return \StructType\RoomRate
     */
    public function setDayRates(\ArrayType\ArrayOfDayRate $dayRates = null)
    {
        $this->DayRates = $dayRates;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\RoomRate
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get PrefPrice value
     * @return string|null
     */
    public function getPrefPrice()
    {
        return $this->PrefPrice;
    }
    /**
     * Set PrefPrice value
     * @param string $prefPrice
     * @return \StructType\RoomRate
     */
    public function setPrefPrice($prefPrice = null)
    {
        // validation for constraint: string
        if (!is_null($prefPrice) && !is_string($prefPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefPrice)), __LINE__);
        }
        $this->PrefPrice = $prefPrice;
        return $this;
    }
    /**
     * Get HeadGSAMarkUp value
     * @return string|null
     */
    public function getHeadGSAMarkUp()
    {
        return $this->HeadGSAMarkUp;
    }
    /**
     * Set HeadGSAMarkUp value
     * @param string $headGSAMarkUp
     * @return \StructType\RoomRate
     */
    public function setHeadGSAMarkUp($headGSAMarkUp = null)
    {
        // validation for constraint: string
        if (!is_null($headGSAMarkUp) && !is_string($headGSAMarkUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($headGSAMarkUp)), __LINE__);
        }
        $this->HeadGSAMarkUp = $headGSAMarkUp;
        return $this;
    }
    /**
     * Get PrefCurrency value
     * @return string|null
     */
    public function getPrefCurrency()
    {
        return $this->PrefCurrency;
    }
    /**
     * Set PrefCurrency value
     * @param string $prefCurrency
     * @return \StructType\RoomRate
     */
    public function setPrefCurrency($prefCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($prefCurrency) && !is_string($prefCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefCurrency)), __LINE__);
        }
        $this->PrefCurrency = $prefCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
