<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomPriceRes StructType
 * @subpackage Structs
 */
class RoomPriceRes extends AbstractStructBase
{
    /**
     * The RoomIndex
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $RoomIndex;
    /**
     * The BeforeAmendmentPrice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $BeforeAmendmentPrice;
    /**
     * The AfterAmendmentPrice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $AfterAmendmentPrice;
    /**
     * The RoomName
     * @var string
     */
    public $RoomName;
    /**
     * Constructor method for RoomPriceRes
     * @uses RoomPriceRes::setRoomIndex()
     * @uses RoomPriceRes::setBeforeAmendmentPrice()
     * @uses RoomPriceRes::setAfterAmendmentPrice()
     * @uses RoomPriceRes::setRoomName()
     * @param string $roomIndex
     * @param float $beforeAmendmentPrice
     * @param float $afterAmendmentPrice
     * @param string $roomName
     */
    public function __construct($roomIndex = null, $beforeAmendmentPrice = null, $afterAmendmentPrice = null, $roomName = null)
    {
        $this
            ->setRoomIndex($roomIndex)
            ->setBeforeAmendmentPrice($beforeAmendmentPrice)
            ->setAfterAmendmentPrice($afterAmendmentPrice)
            ->setRoomName($roomName);
    }
    /**
     * Get RoomIndex value
     * @return string
     */
    public function getRoomIndex()
    {
        return $this->RoomIndex;
    }
    /**
     * Set RoomIndex value
     * @uses \EnumType\RoomRequested::valueIsValid()
     * @uses \EnumType\RoomRequested::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roomIndex
     * @return \StructType\RoomPriceRes
     */
    public function setRoomIndex($roomIndex = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoomRequested::valueIsValid($roomIndex)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roomIndex, implode(', ', \EnumType\RoomRequested::getValidValues())), __LINE__);
        }
        $this->RoomIndex = $roomIndex;
        return $this;
    }
    /**
     * Get BeforeAmendmentPrice value
     * @return float
     */
    public function getBeforeAmendmentPrice()
    {
        return $this->BeforeAmendmentPrice;
    }
    /**
     * Set BeforeAmendmentPrice value
     * @param float $beforeAmendmentPrice
     * @return \StructType\RoomPriceRes
     */
    public function setBeforeAmendmentPrice($beforeAmendmentPrice = null)
    {
        $this->BeforeAmendmentPrice = $beforeAmendmentPrice;
        return $this;
    }
    /**
     * Get AfterAmendmentPrice value
     * @return float
     */
    public function getAfterAmendmentPrice()
    {
        return $this->AfterAmendmentPrice;
    }
    /**
     * Set AfterAmendmentPrice value
     * @param float $afterAmendmentPrice
     * @return \StructType\RoomPriceRes
     */
    public function setAfterAmendmentPrice($afterAmendmentPrice = null)
    {
        $this->AfterAmendmentPrice = $afterAmendmentPrice;
        return $this;
    }
    /**
     * Get RoomName value
     * @return string|null
     */
    public function getRoomName()
    {
        return $this->RoomName;
    }
    /**
     * Set RoomName value
     * @param string $roomName
     * @return \StructType\RoomPriceRes
     */
    public function setRoomName($roomName = null)
    {
        // validation for constraint: string
        if (!is_null($roomName) && !is_string($roomName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomName)), __LINE__);
        }
        $this->RoomName = $roomName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomPriceRes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
