<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomInformation StructType
 * @subpackage Structs
 */
class RoomInformation extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ImageURLs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ImageURLs;
    /**
     * The Amenities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Amenities;
    /**
     * The SmokingPref
     * @var string
     */
    public $SmokingPref;
    /**
     * The MaxOccupancy
     * @var string
     */
    public $MaxOccupancy;
    /**
     * The MaxAge
     * @var string
     */
    public $MaxAge;
    /**
     * The MinAge
     * @var string
     */
    public $MinAge;
    /**
     * The MaxAdult
     * @var string
     */
    public $MaxAdult;
    /**
     * The MaxChild
     * @var string
     */
    public $MaxChild;
    /**
     * Constructor method for RoomInformation
     * @uses RoomInformation::setDescription()
     * @uses RoomInformation::setImageURLs()
     * @uses RoomInformation::setAmenities()
     * @uses RoomInformation::setSmokingPref()
     * @uses RoomInformation::setMaxOccupancy()
     * @uses RoomInformation::setMaxAge()
     * @uses RoomInformation::setMinAge()
     * @uses RoomInformation::setMaxAdult()
     * @uses RoomInformation::setMaxChild()
     * @param string $description
     * @param \ArrayType\ArrayOfString $imageURLs
     * @param \ArrayType\ArrayOfString1 $amenities
     * @param string $smokingPref
     * @param string $maxOccupancy
     * @param string $maxAge
     * @param string $minAge
     * @param string $maxAdult
     * @param string $maxChild
     */
    public function __construct($description = null, \ArrayType\ArrayOfString $imageURLs = null, \ArrayType\ArrayOfString1 $amenities = null, $smokingPref = null, $maxOccupancy = null, $maxAge = null, $minAge = null, $maxAdult = null, $maxChild = null)
    {
        $this
            ->setDescription($description)
            ->setImageURLs($imageURLs)
            ->setAmenities($amenities)
            ->setSmokingPref($smokingPref)
            ->setMaxOccupancy($maxOccupancy)
            ->setMaxAge($maxAge)
            ->setMinAge($minAge)
            ->setMaxAdult($maxAdult)
            ->setMaxChild($maxChild);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\RoomInformation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ImageURLs value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getImageURLs()
    {
        return $this->ImageURLs;
    }
    /**
     * Set ImageURLs value
     * @param \ArrayType\ArrayOfString $imageURLs
     * @return \StructType\RoomInformation
     */
    public function setImageURLs(\ArrayType\ArrayOfString $imageURLs = null)
    {
        $this->ImageURLs = $imageURLs;
        return $this;
    }
    /**
     * Get Amenities value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getAmenities()
    {
        return $this->Amenities;
    }
    /**
     * Set Amenities value
     * @param \ArrayType\ArrayOfString1 $amenities
     * @return \StructType\RoomInformation
     */
    public function setAmenities(\ArrayType\ArrayOfString1 $amenities = null)
    {
        $this->Amenities = $amenities;
        return $this;
    }
    /**
     * Get SmokingPref value
     * @return string|null
     */
    public function getSmokingPref()
    {
        return $this->SmokingPref;
    }
    /**
     * Set SmokingPref value
     * @param string $smokingPref
     * @return \StructType\RoomInformation
     */
    public function setSmokingPref($smokingPref = null)
    {
        // validation for constraint: string
        if (!is_null($smokingPref) && !is_string($smokingPref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($smokingPref)), __LINE__);
        }
        $this->SmokingPref = $smokingPref;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return string|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param string $maxOccupancy
     * @return \StructType\RoomInformation
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: string
        if (!is_null($maxOccupancy) && !is_string($maxOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return string|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param string $maxAge
     * @return \StructType\RoomInformation
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: string
        if (!is_null($maxAge) && !is_string($maxAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxAge)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get MinAge value
     * @return string|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param string $minAge
     * @return \StructType\RoomInformation
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: string
        if (!is_null($minAge) && !is_string($minAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minAge)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAdult value
     * @return string|null
     */
    public function getMaxAdult()
    {
        return $this->MaxAdult;
    }
    /**
     * Set MaxAdult value
     * @param string $maxAdult
     * @return \StructType\RoomInformation
     */
    public function setMaxAdult($maxAdult = null)
    {
        // validation for constraint: string
        if (!is_null($maxAdult) && !is_string($maxAdult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxAdult)), __LINE__);
        }
        $this->MaxAdult = $maxAdult;
        return $this;
    }
    /**
     * Get MaxChild value
     * @return string|null
     */
    public function getMaxChild()
    {
        return $this->MaxChild;
    }
    /**
     * Set MaxChild value
     * @param string $maxChild
     * @return \StructType\RoomInformation
     */
    public function setMaxChild($maxChild = null)
    {
        // validation for constraint: string
        if (!is_null($maxChild) && !is_string($maxChild)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxChild)), __LINE__);
        }
        $this->MaxChild = $maxChild;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
