<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomInfo StructType
 * @subpackage Structs
 */
class RoomInfo extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString6
     */
    public $Images;
    /**
     * The RoomPromotion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomPromotion;
    /**
     * The Inclusion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Inclusion;
    /**
     * The RoomName
     * @var string
     */
    public $RoomName;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * Constructor method for RoomInfo
     * @uses RoomInfo::setDescription()
     * @uses RoomInfo::setImages()
     * @uses RoomInfo::setRoomPromotion()
     * @uses RoomInfo::setInclusion()
     * @uses RoomInfo::setRoomName()
     * @uses RoomInfo::setRoomTypeCode()
     * @param string $description
     * @param \ArrayType\ArrayOfString6 $images
     * @param string $roomPromotion
     * @param string $inclusion
     * @param string $roomName
     * @param string $roomTypeCode
     */
    public function __construct($description = null, \ArrayType\ArrayOfString6 $images = null, $roomPromotion = null, $inclusion = null, $roomName = null, $roomTypeCode = null)
    {
        $this
            ->setDescription($description)
            ->setImages($images)
            ->setRoomPromotion($roomPromotion)
            ->setInclusion($inclusion)
            ->setRoomName($roomName)
            ->setRoomTypeCode($roomTypeCode);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\RoomInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString6|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString6 $images
     * @return \StructType\RoomInfo
     */
    public function setImages(\ArrayType\ArrayOfString6 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get RoomPromotion value
     * @return string|null
     */
    public function getRoomPromotion()
    {
        return $this->RoomPromotion;
    }
    /**
     * Set RoomPromotion value
     * @param string $roomPromotion
     * @return \StructType\RoomInfo
     */
    public function setRoomPromotion($roomPromotion = null)
    {
        // validation for constraint: string
        if (!is_null($roomPromotion) && !is_string($roomPromotion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomPromotion)), __LINE__);
        }
        $this->RoomPromotion = $roomPromotion;
        return $this;
    }
    /**
     * Get Inclusion value
     * @return string|null
     */
    public function getInclusion()
    {
        return $this->Inclusion;
    }
    /**
     * Set Inclusion value
     * @param string $inclusion
     * @return \StructType\RoomInfo
     */
    public function setInclusion($inclusion = null)
    {
        // validation for constraint: string
        if (!is_null($inclusion) && !is_string($inclusion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inclusion)), __LINE__);
        }
        $this->Inclusion = $inclusion;
        return $this;
    }
    /**
     * Get RoomName value
     * @return string|null
     */
    public function getRoomName()
    {
        return $this->RoomName;
    }
    /**
     * Set RoomName value
     * @param string $roomName
     * @return \StructType\RoomInfo
     */
    public function setRoomName($roomName = null)
    {
        // validation for constraint: string
        if (!is_null($roomName) && !is_string($roomName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomName)), __LINE__);
        }
        $this->RoomName = $roomName;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RoomInfo
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
