<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomDetails StructType
 * @subpackage Structs
 */
class RoomDetails extends AbstractStructBase
{
    /**
     * The AdultCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdultCount;
    /**
     * The ChildCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChildCount;
    /**
     * The ChildAge
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $ChildAge;
    /**
     * The RoomName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomName;
    /**
     * The Ameneties
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Ameneties;
    /**
     * The GuestInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuest
     */
    public $GuestInfo;
    /**
     * The Inclusion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Inclusion;
    /**
     * The RoomPromtion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomPromtion;
    /**
     * The RoomInstructions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomInstructions;
    /**
     * The Supplements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSupp_info
     */
    public $Supplements;
    /**
     * The RoomRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RoomRate
     */
    public $RoomRate;
    /**
     * The RoomEssentialInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomEssentialInfo;
    /**
     * Constructor method for RoomDetails
     * @uses RoomDetails::setAdultCount()
     * @uses RoomDetails::setChildCount()
     * @uses RoomDetails::setChildAge()
     * @uses RoomDetails::setRoomName()
     * @uses RoomDetails::setAmeneties()
     * @uses RoomDetails::setGuestInfo()
     * @uses RoomDetails::setInclusion()
     * @uses RoomDetails::setRoomPromtion()
     * @uses RoomDetails::setRoomInstructions()
     * @uses RoomDetails::setSupplements()
     * @uses RoomDetails::setRoomRate()
     * @uses RoomDetails::setRoomEssentialInfo()
     * @param int $adultCount
     * @param int $childCount
     * @param int[] $childAge
     * @param string $roomName
     * @param string[] $ameneties
     * @param \ArrayType\ArrayOfGuest $guestInfo
     * @param string $inclusion
     * @param string $roomPromtion
     * @param string $roomInstructions
     * @param \ArrayType\ArrayOfSupp_info $supplements
     * @param \StructType\RoomRate $roomRate
     * @param string $roomEssentialInfo
     */
    public function __construct($adultCount = null, $childCount = null, array $childAge = array(), $roomName = null, array $ameneties = array(), \ArrayType\ArrayOfGuest $guestInfo = null, $inclusion = null, $roomPromtion = null, $roomInstructions = null, \ArrayType\ArrayOfSupp_info $supplements = null, \StructType\RoomRate $roomRate = null, $roomEssentialInfo = null)
    {
        $this
            ->setAdultCount($adultCount)
            ->setChildCount($childCount)
            ->setChildAge($childAge)
            ->setRoomName($roomName)
            ->setAmeneties($ameneties)
            ->setGuestInfo($guestInfo)
            ->setInclusion($inclusion)
            ->setRoomPromtion($roomPromtion)
            ->setRoomInstructions($roomInstructions)
            ->setSupplements($supplements)
            ->setRoomRate($roomRate)
            ->setRoomEssentialInfo($roomEssentialInfo);
    }
    /**
     * Get AdultCount value
     * @return int
     */
    public function getAdultCount()
    {
        return $this->AdultCount;
    }
    /**
     * Set AdultCount value
     * @param int $adultCount
     * @return \StructType\RoomDetails
     */
    public function setAdultCount($adultCount = null)
    {
        // validation for constraint: int
        if (!is_null($adultCount) && !is_numeric($adultCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adultCount)), __LINE__);
        }
        $this->AdultCount = $adultCount;
        return $this;
    }
    /**
     * Get ChildCount value
     * @return int
     */
    public function getChildCount()
    {
        return $this->ChildCount;
    }
    /**
     * Set ChildCount value
     * @param int $childCount
     * @return \StructType\RoomDetails
     */
    public function setChildCount($childCount = null)
    {
        // validation for constraint: int
        if (!is_null($childCount) && !is_numeric($childCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childCount)), __LINE__);
        }
        $this->ChildCount = $childCount;
        return $this;
    }
    /**
     * Get ChildAge value
     * @return int[]|null
     */
    public function getChildAge()
    {
        return $this->ChildAge;
    }
    /**
     * Set ChildAge value
     * @throws \InvalidArgumentException
     * @param int[] $childAge
     * @return \StructType\RoomDetails
     */
    public function setChildAge(array $childAge = array())
    {
        foreach ($childAge as $roomDetailsChildAgeItem) {
            // validation for constraint: itemType
            if (!is_numeric($roomDetailsChildAgeItem)) {
                throw new \InvalidArgumentException(sprintf('The ChildAge property can only contain items of int, "%s" given', is_object($roomDetailsChildAgeItem) ? get_class($roomDetailsChildAgeItem) : gettype($roomDetailsChildAgeItem)), __LINE__);
            }
        }
        $this->ChildAge = $childAge;
        return $this;
    }
    /**
     * Add item to ChildAge value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\RoomDetails
     */
    public function addToChildAge($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The ChildAge property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChildAge[] = $item;
        return $this;
    }
    /**
     * Get RoomName value
     * @return string|null
     */
    public function getRoomName()
    {
        return $this->RoomName;
    }
    /**
     * Set RoomName value
     * @param string $roomName
     * @return \StructType\RoomDetails
     */
    public function setRoomName($roomName = null)
    {
        // validation for constraint: string
        if (!is_null($roomName) && !is_string($roomName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomName)), __LINE__);
        }
        $this->RoomName = $roomName;
        return $this;
    }
    /**
     * Get Ameneties value
     * @return string[]|null
     */
    public function getAmeneties()
    {
        return $this->Ameneties;
    }
    /**
     * Set Ameneties value
     * @throws \InvalidArgumentException
     * @param string[] $ameneties
     * @return \StructType\RoomDetails
     */
    public function setAmeneties(array $ameneties = array())
    {
        foreach ($ameneties as $roomDetailsAmenetiesItem) {
            // validation for constraint: itemType
            if (!is_string($roomDetailsAmenetiesItem)) {
                throw new \InvalidArgumentException(sprintf('The Ameneties property can only contain items of string, "%s" given', is_object($roomDetailsAmenetiesItem) ? get_class($roomDetailsAmenetiesItem) : gettype($roomDetailsAmenetiesItem)), __LINE__);
            }
        }
        $this->Ameneties = $ameneties;
        return $this;
    }
    /**
     * Add item to Ameneties value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RoomDetails
     */
    public function addToAmeneties($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Ameneties property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Ameneties[] = $item;
        return $this;
    }
    /**
     * Get GuestInfo value
     * @return \ArrayType\ArrayOfGuest|null
     */
    public function getGuestInfo()
    {
        return $this->GuestInfo;
    }
    /**
     * Set GuestInfo value
     * @param \ArrayType\ArrayOfGuest $guestInfo
     * @return \StructType\RoomDetails
     */
    public function setGuestInfo(\ArrayType\ArrayOfGuest $guestInfo = null)
    {
        $this->GuestInfo = $guestInfo;
        return $this;
    }
    /**
     * Get Inclusion value
     * @return string|null
     */
    public function getInclusion()
    {
        return $this->Inclusion;
    }
    /**
     * Set Inclusion value
     * @param string $inclusion
     * @return \StructType\RoomDetails
     */
    public function setInclusion($inclusion = null)
    {
        // validation for constraint: string
        if (!is_null($inclusion) && !is_string($inclusion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inclusion)), __LINE__);
        }
        $this->Inclusion = $inclusion;
        return $this;
    }
    /**
     * Get RoomPromtion value
     * @return string|null
     */
    public function getRoomPromtion()
    {
        return $this->RoomPromtion;
    }
    /**
     * Set RoomPromtion value
     * @param string $roomPromtion
     * @return \StructType\RoomDetails
     */
    public function setRoomPromtion($roomPromtion = null)
    {
        // validation for constraint: string
        if (!is_null($roomPromtion) && !is_string($roomPromtion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomPromtion)), __LINE__);
        }
        $this->RoomPromtion = $roomPromtion;
        return $this;
    }
    /**
     * Get RoomInstructions value
     * @return string|null
     */
    public function getRoomInstructions()
    {
        return $this->RoomInstructions;
    }
    /**
     * Set RoomInstructions value
     * @param string $roomInstructions
     * @return \StructType\RoomDetails
     */
    public function setRoomInstructions($roomInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($roomInstructions) && !is_string($roomInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomInstructions)), __LINE__);
        }
        $this->RoomInstructions = $roomInstructions;
        return $this;
    }
    /**
     * Get Supplements value
     * @return \ArrayType\ArrayOfSupp_info|null
     */
    public function getSupplements()
    {
        return $this->Supplements;
    }
    /**
     * Set Supplements value
     * @param \ArrayType\ArrayOfSupp_info $supplements
     * @return \StructType\RoomDetails
     */
    public function setSupplements(\ArrayType\ArrayOfSupp_info $supplements = null)
    {
        $this->Supplements = $supplements;
        return $this;
    }
    /**
     * Get RoomRate value
     * @return \StructType\RoomRate|null
     */
    public function getRoomRate()
    {
        return $this->RoomRate;
    }
    /**
     * Set RoomRate value
     * @param \StructType\RoomRate $roomRate
     * @return \StructType\RoomDetails
     */
    public function setRoomRate(\StructType\RoomRate $roomRate = null)
    {
        $this->RoomRate = $roomRate;
        return $this;
    }
    /**
     * Get RoomEssentialInfo value
     * @return string|null
     */
    public function getRoomEssentialInfo()
    {
        return $this->RoomEssentialInfo;
    }
    /**
     * Set RoomEssentialInfo value
     * @param string $roomEssentialInfo
     * @return \StructType\RoomDetails
     */
    public function setRoomEssentialInfo($roomEssentialInfo = null)
    {
        // validation for constraint: string
        if (!is_null($roomEssentialInfo) && !is_string($roomEssentialInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomEssentialInfo)), __LINE__);
        }
        $this->RoomEssentialInfo = $roomEssentialInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
