<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestedRooms StructType
 * @subpackage Structs
 */
class RequestedRooms extends AbstractStructBase
{
    /**
     * The RoomIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RoomIndex;
    /**
     * The RoomTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomTypeName;
    /**
     * The RoomTypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The RatePlanCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RoomRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Rate
     */
    public $RoomRate;
    /**
     * The Supplements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSuppInfo
     */
    public $Supplements;
    /**
     * Constructor method for RequestedRooms
     * @uses RequestedRooms::setRoomIndex()
     * @uses RequestedRooms::setRoomTypeName()
     * @uses RequestedRooms::setRoomTypeCode()
     * @uses RequestedRooms::setRatePlanCode()
     * @uses RequestedRooms::setRoomRate()
     * @uses RequestedRooms::setSupplements()
     * @param int $roomIndex
     * @param string $roomTypeName
     * @param string $roomTypeCode
     * @param string $ratePlanCode
     * @param \StructType\Rate $roomRate
     * @param \ArrayType\ArrayOfSuppInfo $supplements
     */
    public function __construct($roomIndex = null, $roomTypeName = null, $roomTypeCode = null, $ratePlanCode = null, \StructType\Rate $roomRate = null, \ArrayType\ArrayOfSuppInfo $supplements = null)
    {
        $this
            ->setRoomIndex($roomIndex)
            ->setRoomTypeName($roomTypeName)
            ->setRoomTypeCode($roomTypeCode)
            ->setRatePlanCode($ratePlanCode)
            ->setRoomRate($roomRate)
            ->setSupplements($supplements);
    }
    /**
     * Get RoomIndex value
     * @return int
     */
    public function getRoomIndex()
    {
        return $this->RoomIndex;
    }
    /**
     * Set RoomIndex value
     * @param int $roomIndex
     * @return \StructType\RequestedRooms
     */
    public function setRoomIndex($roomIndex = null)
    {
        // validation for constraint: int
        if (!is_null($roomIndex) && !is_numeric($roomIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($roomIndex)), __LINE__);
        }
        $this->RoomIndex = $roomIndex;
        return $this;
    }
    /**
     * Get RoomTypeName value
     * @return string|null
     */
    public function getRoomTypeName()
    {
        return $this->RoomTypeName;
    }
    /**
     * Set RoomTypeName value
     * @param string $roomTypeName
     * @return \StructType\RequestedRooms
     */
    public function setRoomTypeName($roomTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeName) && !is_string($roomTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeName)), __LINE__);
        }
        $this->RoomTypeName = $roomTypeName;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RequestedRooms
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RequestedRooms
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RoomRate value
     * @return \StructType\Rate|null
     */
    public function getRoomRate()
    {
        return $this->RoomRate;
    }
    /**
     * Set RoomRate value
     * @param \StructType\Rate $roomRate
     * @return \StructType\RequestedRooms
     */
    public function setRoomRate(\StructType\Rate $roomRate = null)
    {
        $this->RoomRate = $roomRate;
        return $this;
    }
    /**
     * Get Supplements value
     * @return \ArrayType\ArrayOfSuppInfo|null
     */
    public function getSupplements()
    {
        return $this->Supplements;
    }
    /**
     * Set Supplements value
     * @param \ArrayType\ArrayOfSuppInfo $supplements
     * @return \StructType\RequestedRooms
     */
    public function setSupplements(\ArrayType\ArrayOfSuppInfo $supplements = null)
    {
        $this->Supplements = $supplements;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestedRooms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
