<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rate StructType
 * @subpackage Structs
 */
class Rate extends AbstractStructBase
{
    /**
     * The RoomFare
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $RoomFare;
    /**
     * The RoomTax
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $RoomTax;
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $TotalFare;
    /**
     * Constructor method for Rate
     * @uses Rate::setRoomFare()
     * @uses Rate::setRoomTax()
     * @uses Rate::setTotalFare()
     * @param float $roomFare
     * @param float $roomTax
     * @param float $totalFare
     */
    public function __construct($roomFare = null, $roomTax = null, $totalFare = null)
    {
        $this
            ->setRoomFare($roomFare)
            ->setRoomTax($roomTax)
            ->setTotalFare($totalFare);
    }
    /**
     * Get RoomFare value
     * @return float
     */
    public function getRoomFare()
    {
        return $this->RoomFare;
    }
    /**
     * Set RoomFare value
     * @param float $roomFare
     * @return \StructType\Rate
     */
    public function setRoomFare($roomFare = null)
    {
        $this->RoomFare = $roomFare;
        return $this;
    }
    /**
     * Get RoomTax value
     * @return float
     */
    public function getRoomTax()
    {
        return $this->RoomTax;
    }
    /**
     * Set RoomTax value
     * @param float $roomTax
     * @return \StructType\Rate
     */
    public function setRoomTax($roomTax = null)
    {
        $this->RoomTax = $roomTax;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return float
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param float $totalFare
     * @return \StructType\Rate
     */
    public function setTotalFare($totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Rate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
