<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceChangeStatus StructType
 * @subpackage Structs
 */
class PriceChangeStatus extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Status;
    /**
     * The AvailableOnNewPrice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $AvailableOnNewPrice;
    /**
     * The HotelRooms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfHotel_Room
     */
    public $HotelRooms;
    /**
     * The NewPrice
     * @var string
     */
    public $NewPrice;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for PriceChangeStatus
     * @uses PriceChangeStatus::setStatus()
     * @uses PriceChangeStatus::setAvailableOnNewPrice()
     * @uses PriceChangeStatus::setHotelRooms()
     * @uses PriceChangeStatus::setNewPrice()
     * @uses PriceChangeStatus::setCurrency()
     * @param bool $status
     * @param bool $availableOnNewPrice
     * @param \ArrayType\ArrayOfHotel_Room $hotelRooms
     * @param string $newPrice
     * @param string $currency
     */
    public function __construct($status = null, $availableOnNewPrice = null, \ArrayType\ArrayOfHotel_Room $hotelRooms = null, $newPrice = null, $currency = null)
    {
        $this
            ->setStatus($status)
            ->setAvailableOnNewPrice($availableOnNewPrice)
            ->setHotelRooms($hotelRooms)
            ->setNewPrice($newPrice)
            ->setCurrency($currency);
    }
    /**
     * Get Status value
     * @return bool
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\PriceChangeStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get AvailableOnNewPrice value
     * @return bool
     */
    public function getAvailableOnNewPrice()
    {
        return $this->AvailableOnNewPrice;
    }
    /**
     * Set AvailableOnNewPrice value
     * @param bool $availableOnNewPrice
     * @return \StructType\PriceChangeStatus
     */
    public function setAvailableOnNewPrice($availableOnNewPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableOnNewPrice) && !is_bool($availableOnNewPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableOnNewPrice)), __LINE__);
        }
        $this->AvailableOnNewPrice = $availableOnNewPrice;
        return $this;
    }
    /**
     * Get HotelRooms value
     * @return \ArrayType\ArrayOfHotel_Room|null
     */
    public function getHotelRooms()
    {
        return $this->HotelRooms;
    }
    /**
     * Set HotelRooms value
     * @param \ArrayType\ArrayOfHotel_Room $hotelRooms
     * @return \StructType\PriceChangeStatus
     */
    public function setHotelRooms(\ArrayType\ArrayOfHotel_Room $hotelRooms = null)
    {
        $this->HotelRooms = $hotelRooms;
        return $this;
    }
    /**
     * Get NewPrice value
     * @return string|null
     */
    public function getNewPrice()
    {
        return $this->NewPrice;
    }
    /**
     * Set NewPrice value
     * @param string $newPrice
     * @return \StructType\PriceChangeStatus
     */
    public function setNewPrice($newPrice = null)
    {
        // validation for constraint: string
        if (!is_null($newPrice) && !is_string($newPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPrice)), __LINE__);
        }
        $this->NewPrice = $newPrice;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\PriceChangeStatus
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceChangeStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
