<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInfo StructType
 * @subpackage Structs
 */
class PaymentInfo extends AbstractStructBase
{
    /**
     * The VoucherBooking
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $VoucherBooking;
    /**
     * The PaymentModeType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PaymentModeType;
    /**
     * Constructor method for PaymentInfo
     * @uses PaymentInfo::setVoucherBooking()
     * @uses PaymentInfo::setPaymentModeType()
     * @param bool $voucherBooking
     * @param string $paymentModeType
     */
    public function __construct($voucherBooking = null, $paymentModeType = null)
    {
        $this
            ->setVoucherBooking($voucherBooking)
            ->setPaymentModeType($paymentModeType);
    }
    /**
     * Get VoucherBooking value
     * @return bool
     */
    public function getVoucherBooking()
    {
        return $this->VoucherBooking;
    }
    /**
     * Set VoucherBooking value
     * @param bool $voucherBooking
     * @return \StructType\PaymentInfo
     */
    public function setVoucherBooking($voucherBooking = null)
    {
        // validation for constraint: boolean
        if (!is_null($voucherBooking) && !is_bool($voucherBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($voucherBooking)), __LINE__);
        }
        $this->VoucherBooking = $voucherBooking;
        return $this;
    }
    /**
     * Get PaymentModeType value
     * @return string
     */
    public function getPaymentModeType()
    {
        return $this->PaymentModeType;
    }
    /**
     * Set PaymentModeType value
     * @uses \EnumType\PaymentModeType::valueIsValid()
     * @uses \EnumType\PaymentModeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentModeType
     * @return \StructType\PaymentInfo
     */
    public function setPaymentModeType($paymentModeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentModeType::valueIsValid($paymentModeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentModeType, implode(', ', \EnumType\PaymentModeType::getValidValues())), __LINE__);
        }
        $this->PaymentModeType = $paymentModeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
