<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hotel_Room StructType
 * @subpackage Structs
 */
class Hotel_Room extends AbstractStructBase
{
    /**
     * The RoomIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RoomIndex;
    /**
     * The RoomTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomTypeName;
    /**
     * The Inclusion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Inclusion;
    /**
     * The RoomTypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The RatePlanCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RoomRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RoomRate
     */
    public $RoomRate;
    /**
     * The RoomPromtion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomPromtion;
    /**
     * The RoomInstructions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomInstructions;
    /**
     * The Supplements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSupplement
     */
    public $Supplements;
    /**
     * The RoomEssentialInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomEssentialInfo;
    /**
     * The RoomAdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RoomInformation
     */
    public $RoomAdditionalInfo;
    /**
     * The CancelPolicies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CancelPolicies
     */
    public $CancelPolicies;
    /**
     * Constructor method for Hotel_Room
     * @uses Hotel_Room::setRoomIndex()
     * @uses Hotel_Room::setRoomTypeName()
     * @uses Hotel_Room::setInclusion()
     * @uses Hotel_Room::setRoomTypeCode()
     * @uses Hotel_Room::setRatePlanCode()
     * @uses Hotel_Room::setRoomRate()
     * @uses Hotel_Room::setRoomPromtion()
     * @uses Hotel_Room::setRoomInstructions()
     * @uses Hotel_Room::setSupplements()
     * @uses Hotel_Room::setRoomEssentialInfo()
     * @uses Hotel_Room::setRoomAdditionalInfo()
     * @uses Hotel_Room::setCancelPolicies()
     * @param int $roomIndex
     * @param string $roomTypeName
     * @param string $inclusion
     * @param string $roomTypeCode
     * @param string $ratePlanCode
     * @param \StructType\RoomRate $roomRate
     * @param string $roomPromtion
     * @param string $roomInstructions
     * @param \ArrayType\ArrayOfSupplement $supplements
     * @param string $roomEssentialInfo
     * @param \StructType\RoomInformation $roomAdditionalInfo
     * @param \StructType\CancelPolicies $cancelPolicies
     */
    public function __construct($roomIndex = null, $roomTypeName = null, $inclusion = null, $roomTypeCode = null, $ratePlanCode = null, \StructType\RoomRate $roomRate = null, $roomPromtion = null, $roomInstructions = null, \ArrayType\ArrayOfSupplement $supplements = null, $roomEssentialInfo = null, \StructType\RoomInformation $roomAdditionalInfo = null, \StructType\CancelPolicies $cancelPolicies = null)
    {
        $this
            ->setRoomIndex($roomIndex)
            ->setRoomTypeName($roomTypeName)
            ->setInclusion($inclusion)
            ->setRoomTypeCode($roomTypeCode)
            ->setRatePlanCode($ratePlanCode)
            ->setRoomRate($roomRate)
            ->setRoomPromtion($roomPromtion)
            ->setRoomInstructions($roomInstructions)
            ->setSupplements($supplements)
            ->setRoomEssentialInfo($roomEssentialInfo)
            ->setRoomAdditionalInfo($roomAdditionalInfo)
            ->setCancelPolicies($cancelPolicies);
    }
    /**
     * Get RoomIndex value
     * @return int
     */
    public function getRoomIndex()
    {
        return $this->RoomIndex;
    }
    /**
     * Set RoomIndex value
     * @param int $roomIndex
     * @return \StructType\Hotel_Room
     */
    public function setRoomIndex($roomIndex = null)
    {
        // validation for constraint: int
        if (!is_null($roomIndex) && !is_numeric($roomIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($roomIndex)), __LINE__);
        }
        $this->RoomIndex = $roomIndex;
        return $this;
    }
    /**
     * Get RoomTypeName value
     * @return string|null
     */
    public function getRoomTypeName()
    {
        return $this->RoomTypeName;
    }
    /**
     * Set RoomTypeName value
     * @param string $roomTypeName
     * @return \StructType\Hotel_Room
     */
    public function setRoomTypeName($roomTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeName) && !is_string($roomTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeName)), __LINE__);
        }
        $this->RoomTypeName = $roomTypeName;
        return $this;
    }
    /**
     * Get Inclusion value
     * @return string|null
     */
    public function getInclusion()
    {
        return $this->Inclusion;
    }
    /**
     * Set Inclusion value
     * @param string $inclusion
     * @return \StructType\Hotel_Room
     */
    public function setInclusion($inclusion = null)
    {
        // validation for constraint: string
        if (!is_null($inclusion) && !is_string($inclusion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inclusion)), __LINE__);
        }
        $this->Inclusion = $inclusion;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\Hotel_Room
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\Hotel_Room
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RoomRate value
     * @return \StructType\RoomRate|null
     */
    public function getRoomRate()
    {
        return $this->RoomRate;
    }
    /**
     * Set RoomRate value
     * @param \StructType\RoomRate $roomRate
     * @return \StructType\Hotel_Room
     */
    public function setRoomRate(\StructType\RoomRate $roomRate = null)
    {
        $this->RoomRate = $roomRate;
        return $this;
    }
    /**
     * Get RoomPromtion value
     * @return string|null
     */
    public function getRoomPromtion()
    {
        return $this->RoomPromtion;
    }
    /**
     * Set RoomPromtion value
     * @param string $roomPromtion
     * @return \StructType\Hotel_Room
     */
    public function setRoomPromtion($roomPromtion = null)
    {
        // validation for constraint: string
        if (!is_null($roomPromtion) && !is_string($roomPromtion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomPromtion)), __LINE__);
        }
        $this->RoomPromtion = $roomPromtion;
        return $this;
    }
    /**
     * Get RoomInstructions value
     * @return string|null
     */
    public function getRoomInstructions()
    {
        return $this->RoomInstructions;
    }
    /**
     * Set RoomInstructions value
     * @param string $roomInstructions
     * @return \StructType\Hotel_Room
     */
    public function setRoomInstructions($roomInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($roomInstructions) && !is_string($roomInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomInstructions)), __LINE__);
        }
        $this->RoomInstructions = $roomInstructions;
        return $this;
    }
    /**
     * Get Supplements value
     * @return \ArrayType\ArrayOfSupplement|null
     */
    public function getSupplements()
    {
        return $this->Supplements;
    }
    /**
     * Set Supplements value
     * @param \ArrayType\ArrayOfSupplement $supplements
     * @return \StructType\Hotel_Room
     */
    public function setSupplements(\ArrayType\ArrayOfSupplement $supplements = null)
    {
        $this->Supplements = $supplements;
        return $this;
    }
    /**
     * Get RoomEssentialInfo value
     * @return string|null
     */
    public function getRoomEssentialInfo()
    {
        return $this->RoomEssentialInfo;
    }
    /**
     * Set RoomEssentialInfo value
     * @param string $roomEssentialInfo
     * @return \StructType\Hotel_Room
     */
    public function setRoomEssentialInfo($roomEssentialInfo = null)
    {
        // validation for constraint: string
        if (!is_null($roomEssentialInfo) && !is_string($roomEssentialInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomEssentialInfo)), __LINE__);
        }
        $this->RoomEssentialInfo = $roomEssentialInfo;
        return $this;
    }
    /**
     * Get RoomAdditionalInfo value
     * @return \StructType\RoomInformation|null
     */
    public function getRoomAdditionalInfo()
    {
        return $this->RoomAdditionalInfo;
    }
    /**
     * Set RoomAdditionalInfo value
     * @param \StructType\RoomInformation $roomAdditionalInfo
     * @return \StructType\Hotel_Room
     */
    public function setRoomAdditionalInfo(\StructType\RoomInformation $roomAdditionalInfo = null)
    {
        $this->RoomAdditionalInfo = $roomAdditionalInfo;
        return $this;
    }
    /**
     * Get CancelPolicies value
     * @return \StructType\CancelPolicies|null
     */
    public function getCancelPolicies()
    {
        return $this->CancelPolicies;
    }
    /**
     * Set CancelPolicies value
     * @param \StructType\CancelPolicies $cancelPolicies
     * @return \StructType\Hotel_Room
     */
    public function setCancelPolicies(\StructType\CancelPolicies $cancelPolicies = null)
    {
        $this->CancelPolicies = $cancelPolicies;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Hotel_Room
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
