<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hotel_Result StructType
 * @subpackage Structs
 */
class Hotel_Result extends AbstractStructBase
{
    /**
     * The ResultIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultIndex;
    /**
     * The IsPkgProperty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPkgProperty;
    /**
     * The IsPackageRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPackageRate;
    /**
     * The MappedHotel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MappedHotel;
    /**
     * The HotelInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelInfo
     */
    public $HotelInfo;
    /**
     * The MinHotelPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MinHotelPrice
     */
    public $MinHotelPrice;
    /**
     * The RoomDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRooms
     */
    public $RoomDetails;
    /**
     * Constructor method for Hotel_Result
     * @uses Hotel_Result::setResultIndex()
     * @uses Hotel_Result::setIsPkgProperty()
     * @uses Hotel_Result::setIsPackageRate()
     * @uses Hotel_Result::setMappedHotel()
     * @uses Hotel_Result::setHotelInfo()
     * @uses Hotel_Result::setMinHotelPrice()
     * @uses Hotel_Result::setRoomDetails()
     * @param int $resultIndex
     * @param bool $isPkgProperty
     * @param bool $isPackageRate
     * @param bool $mappedHotel
     * @param \StructType\HotelInfo $hotelInfo
     * @param \StructType\MinHotelPrice $minHotelPrice
     * @param \ArrayType\ArrayOfRooms $roomDetails
     */
    public function __construct($resultIndex = null, $isPkgProperty = null, $isPackageRate = null, $mappedHotel = null, \StructType\HotelInfo $hotelInfo = null, \StructType\MinHotelPrice $minHotelPrice = null, \ArrayType\ArrayOfRooms $roomDetails = null)
    {
        $this
            ->setResultIndex($resultIndex)
            ->setIsPkgProperty($isPkgProperty)
            ->setIsPackageRate($isPackageRate)
            ->setMappedHotel($mappedHotel)
            ->setHotelInfo($hotelInfo)
            ->setMinHotelPrice($minHotelPrice)
            ->setRoomDetails($roomDetails);
    }
    /**
     * Get ResultIndex value
     * @return int
     */
    public function getResultIndex()
    {
        return $this->ResultIndex;
    }
    /**
     * Set ResultIndex value
     * @param int $resultIndex
     * @return \StructType\Hotel_Result
     */
    public function setResultIndex($resultIndex = null)
    {
        // validation for constraint: int
        if (!is_null($resultIndex) && !is_numeric($resultIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultIndex)), __LINE__);
        }
        $this->ResultIndex = $resultIndex;
        return $this;
    }
    /**
     * Get IsPkgProperty value
     * @return bool
     */
    public function getIsPkgProperty()
    {
        return $this->IsPkgProperty;
    }
    /**
     * Set IsPkgProperty value
     * @param bool $isPkgProperty
     * @return \StructType\Hotel_Result
     */
    public function setIsPkgProperty($isPkgProperty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPkgProperty) && !is_bool($isPkgProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPkgProperty)), __LINE__);
        }
        $this->IsPkgProperty = $isPkgProperty;
        return $this;
    }
    /**
     * Get IsPackageRate value
     * @return bool
     */
    public function getIsPackageRate()
    {
        return $this->IsPackageRate;
    }
    /**
     * Set IsPackageRate value
     * @param bool $isPackageRate
     * @return \StructType\Hotel_Result
     */
    public function setIsPackageRate($isPackageRate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPackageRate) && !is_bool($isPackageRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPackageRate)), __LINE__);
        }
        $this->IsPackageRate = $isPackageRate;
        return $this;
    }
    /**
     * Get MappedHotel value
     * @return bool
     */
    public function getMappedHotel()
    {
        return $this->MappedHotel;
    }
    /**
     * Set MappedHotel value
     * @param bool $mappedHotel
     * @return \StructType\Hotel_Result
     */
    public function setMappedHotel($mappedHotel = null)
    {
        // validation for constraint: boolean
        if (!is_null($mappedHotel) && !is_bool($mappedHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mappedHotel)), __LINE__);
        }
        $this->MappedHotel = $mappedHotel;
        return $this;
    }
    /**
     * Get HotelInfo value
     * @return \StructType\HotelInfo|null
     */
    public function getHotelInfo()
    {
        return $this->HotelInfo;
    }
    /**
     * Set HotelInfo value
     * @param \StructType\HotelInfo $hotelInfo
     * @return \StructType\Hotel_Result
     */
    public function setHotelInfo(\StructType\HotelInfo $hotelInfo = null)
    {
        $this->HotelInfo = $hotelInfo;
        return $this;
    }
    /**
     * Get MinHotelPrice value
     * @return \StructType\MinHotelPrice|null
     */
    public function getMinHotelPrice()
    {
        return $this->MinHotelPrice;
    }
    /**
     * Set MinHotelPrice value
     * @param \StructType\MinHotelPrice $minHotelPrice
     * @return \StructType\Hotel_Result
     */
    public function setMinHotelPrice(\StructType\MinHotelPrice $minHotelPrice = null)
    {
        $this->MinHotelPrice = $minHotelPrice;
        return $this;
    }
    /**
     * Get RoomDetails value
     * @return \ArrayType\ArrayOfRooms|null
     */
    public function getRoomDetails()
    {
        return $this->RoomDetails;
    }
    /**
     * Set RoomDetails value
     * @param \ArrayType\ArrayOfRooms $roomDetails
     * @return \StructType\Hotel_Result
     */
    public function setRoomDetails(\ArrayType\ArrayOfRooms $roomDetails = null)
    {
        $this->RoomDetails = $roomDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Hotel_Result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
