<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearchWithRoomsResponse StructType
 * @subpackage Structs
 */
class HotelSearchWithRoomsResponse extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseStatus
     */
    public $Status;
    /**
     * The ResponseTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseTime;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The SessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SessionId;
    /**
     * The NoOfRoomsRequested
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoOfRoomsRequested;
    /**
     * The CityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityId;
    /**
     * The CheckInDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckInDate;
    /**
     * The CheckOutDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckOutDate;
    /**
     * The RoomGuests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoomGuest
     */
    public $RoomGuests;
    /**
     * The HotelResultList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfHotel_ResultWithRooms
     */
    public $HotelResultList;
    /**
     * Constructor method for HotelSearchWithRoomsResponse
     * @uses HotelSearchWithRoomsResponse::setStatus()
     * @uses HotelSearchWithRoomsResponse::setResponseTime()
     * @uses HotelSearchWithRoomsResponse::setLanguage()
     * @uses HotelSearchWithRoomsResponse::setSessionId()
     * @uses HotelSearchWithRoomsResponse::setNoOfRoomsRequested()
     * @uses HotelSearchWithRoomsResponse::setCityId()
     * @uses HotelSearchWithRoomsResponse::setCheckInDate()
     * @uses HotelSearchWithRoomsResponse::setCheckOutDate()
     * @uses HotelSearchWithRoomsResponse::setRoomGuests()
     * @uses HotelSearchWithRoomsResponse::setHotelResultList()
     * @param \StructType\ResponseStatus $status
     * @param string $responseTime
     * @param string $language
     * @param string $sessionId
     * @param string $noOfRoomsRequested
     * @param string $cityId
     * @param string $checkInDate
     * @param string $checkOutDate
     * @param \ArrayType\ArrayOfRoomGuest $roomGuests
     * @param \ArrayType\ArrayOfHotel_ResultWithRooms $hotelResultList
     */
    public function __construct(\StructType\ResponseStatus $status = null, $responseTime = null, $language = null, $sessionId = null, $noOfRoomsRequested = null, $cityId = null, $checkInDate = null, $checkOutDate = null, \ArrayType\ArrayOfRoomGuest $roomGuests = null, \ArrayType\ArrayOfHotel_ResultWithRooms $hotelResultList = null)
    {
        $this
            ->setStatus($status)
            ->setResponseTime($responseTime)
            ->setLanguage($language)
            ->setSessionId($sessionId)
            ->setNoOfRoomsRequested($noOfRoomsRequested)
            ->setCityId($cityId)
            ->setCheckInDate($checkInDate)
            ->setCheckOutDate($checkOutDate)
            ->setRoomGuests($roomGuests)
            ->setHotelResultList($hotelResultList);
    }
    /**
     * Get Status value
     * @return \StructType\ResponseStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\ResponseStatus $status
     * @return \StructType\HotelSearchWithRoomsResponse
     */
    public function setStatus(\StructType\ResponseStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ResponseTime value
     * @return string|null
     */
    public function getResponseTime()
    {
        return $this->ResponseTime;
    }
    /**
     * Set ResponseTime value
     * @param string $responseTime
     * @return \StructType\HotelSearchWithRoomsResponse
     */
    public function setResponseTime($responseTime = null)
    {
        // validation for constraint: string
        if (!is_null($responseTime) && !is_string($responseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseTime)), __LINE__);
        }
        $this->ResponseTime = $responseTime;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\HotelSearchWithRoomsResponse
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get SessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param string $sessionId
     * @return \StructType\HotelSearchWithRoomsResponse
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get NoOfRoomsRequested value
     * @return string|null
     */
    public function getNoOfRoomsRequested()
    {
        return $this->NoOfRoomsRequested;
    }
    /**
     * Set NoOfRoomsRequested value
     * @param string $noOfRoomsRequested
     * @return \StructType\HotelSearchWithRoomsResponse
     */
    public function setNoOfRoomsRequested($noOfRoomsRequested = null)
    {
        // validation for constraint: string
        if (!is_null($noOfRoomsRequested) && !is_string($noOfRoomsRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noOfRoomsRequested)), __LINE__);
        }
        $this->NoOfRoomsRequested = $noOfRoomsRequested;
        return $this;
    }
    /**
     * Get CityId value
     * @return string|null
     */
    public function getCityId()
    {
        return $this->CityId;
    }
    /**
     * Set CityId value
     * @param string $cityId
     * @return \StructType\HotelSearchWithRoomsResponse
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: string
        if (!is_null($cityId) && !is_string($cityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityId)), __LINE__);
        }
        $this->CityId = $cityId;
        return $this;
    }
    /**
     * Get CheckInDate value
     * @return string|null
     */
    public function getCheckInDate()
    {
        return $this->CheckInDate;
    }
    /**
     * Set CheckInDate value
     * @param string $checkInDate
     * @return \StructType\HotelSearchWithRoomsResponse
     */
    public function setCheckInDate($checkInDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDate) && !is_string($checkInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkInDate)), __LINE__);
        }
        $this->CheckInDate = $checkInDate;
        return $this;
    }
    /**
     * Get CheckOutDate value
     * @return string|null
     */
    public function getCheckOutDate()
    {
        return $this->CheckOutDate;
    }
    /**
     * Set CheckOutDate value
     * @param string $checkOutDate
     * @return \StructType\HotelSearchWithRoomsResponse
     */
    public function setCheckOutDate($checkOutDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkOutDate) && !is_string($checkOutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkOutDate)), __LINE__);
        }
        $this->CheckOutDate = $checkOutDate;
        return $this;
    }
    /**
     * Get RoomGuests value
     * @return \ArrayType\ArrayOfRoomGuest|null
     */
    public function getRoomGuests()
    {
        return $this->RoomGuests;
    }
    /**
     * Set RoomGuests value
     * @param \ArrayType\ArrayOfRoomGuest $roomGuests
     * @return \StructType\HotelSearchWithRoomsResponse
     */
    public function setRoomGuests(\ArrayType\ArrayOfRoomGuest $roomGuests = null)
    {
        $this->RoomGuests = $roomGuests;
        return $this;
    }
    /**
     * Get HotelResultList value
     * @return \ArrayType\ArrayOfHotel_ResultWithRooms|null
     */
    public function getHotelResultList()
    {
        return $this->HotelResultList;
    }
    /**
     * Set HotelResultList value
     * @param \ArrayType\ArrayOfHotel_ResultWithRooms $hotelResultList
     * @return \StructType\HotelSearchWithRoomsResponse
     */
    public function setHotelResultList(\ArrayType\ArrayOfHotel_ResultWithRooms $hotelResultList = null)
    {
        $this->HotelResultList = $hotelResultList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelSearchWithRoomsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
