<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelInfo StructType
 * @subpackage Structs
 */
class HotelInfo extends AbstractStructBase
{
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Longitude;
    /**
     * The Rating
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Rating;
    /**
     * The HotelCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelName;
    /**
     * The HotelPicture
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelPicture;
    /**
     * The HotelDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelDescription;
    /**
     * The HotelAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelAddress;
    /**
     * The HotelContactNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelContactNo;
    /**
     * The HotelPromotion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelPromotion;
    /**
     * The TripAdvisorRating
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripAdvisorRating;
    /**
     * The TripAdvisorReviewURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripAdvisorReviewURL;
    /**
     * The TagIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TagIds;
    /**
     * Constructor method for HotelInfo
     * @uses HotelInfo::setLatitude()
     * @uses HotelInfo::setLongitude()
     * @uses HotelInfo::setRating()
     * @uses HotelInfo::setHotelCode()
     * @uses HotelInfo::setHotelName()
     * @uses HotelInfo::setHotelPicture()
     * @uses HotelInfo::setHotelDescription()
     * @uses HotelInfo::setHotelAddress()
     * @uses HotelInfo::setHotelContactNo()
     * @uses HotelInfo::setHotelPromotion()
     * @uses HotelInfo::setTripAdvisorRating()
     * @uses HotelInfo::setTripAdvisorReviewURL()
     * @uses HotelInfo::setTagIds()
     * @param float $latitude
     * @param float $longitude
     * @param string $rating
     * @param string $hotelCode
     * @param string $hotelName
     * @param string $hotelPicture
     * @param string $hotelDescription
     * @param string $hotelAddress
     * @param string $hotelContactNo
     * @param string $hotelPromotion
     * @param string $tripAdvisorRating
     * @param string $tripAdvisorReviewURL
     * @param string $tagIds
     */
    public function __construct($latitude = null, $longitude = null, $rating = null, $hotelCode = null, $hotelName = null, $hotelPicture = null, $hotelDescription = null, $hotelAddress = null, $hotelContactNo = null, $hotelPromotion = null, $tripAdvisorRating = null, $tripAdvisorReviewURL = null, $tagIds = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setRating($rating)
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName)
            ->setHotelPicture($hotelPicture)
            ->setHotelDescription($hotelDescription)
            ->setHotelAddress($hotelAddress)
            ->setHotelContactNo($hotelContactNo)
            ->setHotelPromotion($hotelPromotion)
            ->setTripAdvisorRating($tripAdvisorRating)
            ->setTripAdvisorReviewURL($tripAdvisorReviewURL)
            ->setTagIds($tagIds);
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\HotelInfo
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\HotelInfo
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Rating value
     * @return string
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @uses \EnumType\HotelInfoHotelRating::valueIsValid()
     * @uses \EnumType\HotelInfoHotelRating::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rating
     * @return \StructType\HotelInfo
     */
    public function setRating($rating = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelInfoHotelRating::valueIsValid($rating)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rating, implode(', ', \EnumType\HotelInfoHotelRating::getValidValues())), __LINE__);
        }
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\HotelInfo
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\HotelInfo
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelPicture value
     * @return string|null
     */
    public function getHotelPicture()
    {
        return $this->HotelPicture;
    }
    /**
     * Set HotelPicture value
     * @param string $hotelPicture
     * @return \StructType\HotelInfo
     */
    public function setHotelPicture($hotelPicture = null)
    {
        // validation for constraint: string
        if (!is_null($hotelPicture) && !is_string($hotelPicture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelPicture)), __LINE__);
        }
        $this->HotelPicture = $hotelPicture;
        return $this;
    }
    /**
     * Get HotelDescription value
     * @return string|null
     */
    public function getHotelDescription()
    {
        return $this->HotelDescription;
    }
    /**
     * Set HotelDescription value
     * @param string $hotelDescription
     * @return \StructType\HotelInfo
     */
    public function setHotelDescription($hotelDescription = null)
    {
        // validation for constraint: string
        if (!is_null($hotelDescription) && !is_string($hotelDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelDescription)), __LINE__);
        }
        $this->HotelDescription = $hotelDescription;
        return $this;
    }
    /**
     * Get HotelAddress value
     * @return string|null
     */
    public function getHotelAddress()
    {
        return $this->HotelAddress;
    }
    /**
     * Set HotelAddress value
     * @param string $hotelAddress
     * @return \StructType\HotelInfo
     */
    public function setHotelAddress($hotelAddress = null)
    {
        // validation for constraint: string
        if (!is_null($hotelAddress) && !is_string($hotelAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelAddress)), __LINE__);
        }
        $this->HotelAddress = $hotelAddress;
        return $this;
    }
    /**
     * Get HotelContactNo value
     * @return string|null
     */
    public function getHotelContactNo()
    {
        return $this->HotelContactNo;
    }
    /**
     * Set HotelContactNo value
     * @param string $hotelContactNo
     * @return \StructType\HotelInfo
     */
    public function setHotelContactNo($hotelContactNo = null)
    {
        // validation for constraint: string
        if (!is_null($hotelContactNo) && !is_string($hotelContactNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelContactNo)), __LINE__);
        }
        $this->HotelContactNo = $hotelContactNo;
        return $this;
    }
    /**
     * Get HotelPromotion value
     * @return string|null
     */
    public function getHotelPromotion()
    {
        return $this->HotelPromotion;
    }
    /**
     * Set HotelPromotion value
     * @param string $hotelPromotion
     * @return \StructType\HotelInfo
     */
    public function setHotelPromotion($hotelPromotion = null)
    {
        // validation for constraint: string
        if (!is_null($hotelPromotion) && !is_string($hotelPromotion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelPromotion)), __LINE__);
        }
        $this->HotelPromotion = $hotelPromotion;
        return $this;
    }
    /**
     * Get TripAdvisorRating value
     * @return string|null
     */
    public function getTripAdvisorRating()
    {
        return $this->TripAdvisorRating;
    }
    /**
     * Set TripAdvisorRating value
     * @param string $tripAdvisorRating
     * @return \StructType\HotelInfo
     */
    public function setTripAdvisorRating($tripAdvisorRating = null)
    {
        // validation for constraint: string
        if (!is_null($tripAdvisorRating) && !is_string($tripAdvisorRating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tripAdvisorRating)), __LINE__);
        }
        $this->TripAdvisorRating = $tripAdvisorRating;
        return $this;
    }
    /**
     * Get TripAdvisorReviewURL value
     * @return string|null
     */
    public function getTripAdvisorReviewURL()
    {
        return $this->TripAdvisorReviewURL;
    }
    /**
     * Set TripAdvisorReviewURL value
     * @param string $tripAdvisorReviewURL
     * @return \StructType\HotelInfo
     */
    public function setTripAdvisorReviewURL($tripAdvisorReviewURL = null)
    {
        // validation for constraint: string
        if (!is_null($tripAdvisorReviewURL) && !is_string($tripAdvisorReviewURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tripAdvisorReviewURL)), __LINE__);
        }
        $this->TripAdvisorReviewURL = $tripAdvisorReviewURL;
        return $this;
    }
    /**
     * Get TagIds value
     * @return string|null
     */
    public function getTagIds()
    {
        return $this->TagIds;
    }
    /**
     * Set TagIds value
     * @param string $tagIds
     * @return \StructType\HotelInfo
     */
    public function setTagIds($tagIds = null)
    {
        // validation for constraint: string
        if (!is_null($tagIds) && !is_string($tagIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tagIds)), __LINE__);
        }
        $this->TagIds = $tagIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
