<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelDetailsVerification StructType
 * @subpackage Structs
 */
class HotelDetailsVerification extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The Remarks
     * @var string
     */
    public $Remarks;
    /**
     * Constructor method for HotelDetailsVerification
     * @uses HotelDetailsVerification::setStatus()
     * @uses HotelDetailsVerification::setRemarks()
     * @param string $status
     * @param string $remarks
     */
    public function __construct($status = null, $remarks = null)
    {
        $this
            ->setStatus($status)
            ->setRemarks($remarks);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\HotelDetailsVerificationStatus::valueIsValid()
     * @uses \EnumType\HotelDetailsVerificationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\HotelDetailsVerification
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelDetailsVerificationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\HotelDetailsVerificationStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\HotelDetailsVerification
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelDetailsVerification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
