<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelBookingDetailRequest StructType
 * @subpackage Structs
 */
class HotelBookingDetailRequest extends AbstractStructBase
{
    /**
     * The BookingId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BookingId;
    /**
     * The ConfirmationNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNo;
    /**
     * The ClientReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientReferenceNumber;
    /**
     * Constructor method for HotelBookingDetailRequest
     * @uses HotelBookingDetailRequest::setBookingId()
     * @uses HotelBookingDetailRequest::setConfirmationNo()
     * @uses HotelBookingDetailRequest::setClientReferenceNumber()
     * @param int $bookingId
     * @param string $confirmationNo
     * @param string $clientReferenceNumber
     */
    public function __construct($bookingId = null, $confirmationNo = null, $clientReferenceNumber = null)
    {
        $this
            ->setBookingId($bookingId)
            ->setConfirmationNo($confirmationNo)
            ->setClientReferenceNumber($clientReferenceNumber);
    }
    /**
     * Get BookingId value
     * @return int
     */
    public function getBookingId()
    {
        return $this->BookingId;
    }
    /**
     * Set BookingId value
     * @param int $bookingId
     * @return \StructType\HotelBookingDetailRequest
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: int
        if (!is_null($bookingId) && !is_numeric($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bookingId)), __LINE__);
        }
        $this->BookingId = $bookingId;
        return $this;
    }
    /**
     * Get ConfirmationNo value
     * @return string|null
     */
    public function getConfirmationNo()
    {
        return $this->ConfirmationNo;
    }
    /**
     * Set ConfirmationNo value
     * @param string $confirmationNo
     * @return \StructType\HotelBookingDetailRequest
     */
    public function setConfirmationNo($confirmationNo = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNo) && !is_string($confirmationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confirmationNo)), __LINE__);
        }
        $this->ConfirmationNo = $confirmationNo;
        return $this;
    }
    /**
     * Get ClientReferenceNumber value
     * @return string|null
     */
    public function getClientReferenceNumber()
    {
        return $this->ClientReferenceNumber;
    }
    /**
     * Set ClientReferenceNumber value
     * @param string $clientReferenceNumber
     * @return \StructType\HotelBookingDetailRequest
     */
    public function setClientReferenceNumber($clientReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($clientReferenceNumber) && !is_string($clientReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientReferenceNumber)), __LINE__);
        }
        $this->ClientReferenceNumber = $clientReferenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelBookingDetailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
