<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelBookRequest StructType
 * @subpackage Structs
 */
class HotelBookRequest extends AbstractStructBase
{
    /**
     * The NoOfRooms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NoOfRooms;
    /**
     * The ResultIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultIndex;
    /**
     * The RestrictDuplicateBooking
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RestrictDuplicateBooking;
    /**
     * The ClientReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientReferenceNumber;
    /**
     * The GuestNationality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GuestNationality;
    /**
     * The Guests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuest
     */
    public $Guests;
    /**
     * The AddressInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressInfo
     */
    public $AddressInfo;
    /**
     * The PaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentInfo
     */
    public $PaymentInfo;
    /**
     * The SessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SessionId;
    /**
     * The FlightInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlightInfo;
    /**
     * The HotelCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelName;
    /**
     * The HotelRooms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRequestedRooms
     */
    public $HotelRooms;
    /**
     * The SpecialRequests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSpecialRequest
     */
    public $SpecialRequests;
    /**
     * The AgencyReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyReferenceNumber;
    /**
     * Constructor method for HotelBookRequest
     * @uses HotelBookRequest::setNoOfRooms()
     * @uses HotelBookRequest::setResultIndex()
     * @uses HotelBookRequest::setRestrictDuplicateBooking()
     * @uses HotelBookRequest::setClientReferenceNumber()
     * @uses HotelBookRequest::setGuestNationality()
     * @uses HotelBookRequest::setGuests()
     * @uses HotelBookRequest::setAddressInfo()
     * @uses HotelBookRequest::setPaymentInfo()
     * @uses HotelBookRequest::setSessionId()
     * @uses HotelBookRequest::setFlightInfo()
     * @uses HotelBookRequest::setHotelCode()
     * @uses HotelBookRequest::setHotelName()
     * @uses HotelBookRequest::setHotelRooms()
     * @uses HotelBookRequest::setSpecialRequests()
     * @uses HotelBookRequest::setAgencyReferenceNumber()
     * @param int $noOfRooms
     * @param int $resultIndex
     * @param bool $restrictDuplicateBooking
     * @param string $clientReferenceNumber
     * @param string $guestNationality
     * @param \ArrayType\ArrayOfGuest $guests
     * @param \StructType\AddressInfo $addressInfo
     * @param \StructType\PaymentInfo $paymentInfo
     * @param string $sessionId
     * @param string $flightInfo
     * @param string $hotelCode
     * @param string $hotelName
     * @param \ArrayType\ArrayOfRequestedRooms $hotelRooms
     * @param \ArrayType\ArrayOfSpecialRequest $specialRequests
     * @param string $agencyReferenceNumber
     */
    public function __construct($noOfRooms = null, $resultIndex = null, $restrictDuplicateBooking = null, $clientReferenceNumber = null, $guestNationality = null, \ArrayType\ArrayOfGuest $guests = null, \StructType\AddressInfo $addressInfo = null, \StructType\PaymentInfo $paymentInfo = null, $sessionId = null, $flightInfo = null, $hotelCode = null, $hotelName = null, \ArrayType\ArrayOfRequestedRooms $hotelRooms = null, \ArrayType\ArrayOfSpecialRequest $specialRequests = null, $agencyReferenceNumber = null)
    {
        $this
            ->setNoOfRooms($noOfRooms)
            ->setResultIndex($resultIndex)
            ->setRestrictDuplicateBooking($restrictDuplicateBooking)
            ->setClientReferenceNumber($clientReferenceNumber)
            ->setGuestNationality($guestNationality)
            ->setGuests($guests)
            ->setAddressInfo($addressInfo)
            ->setPaymentInfo($paymentInfo)
            ->setSessionId($sessionId)
            ->setFlightInfo($flightInfo)
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName)
            ->setHotelRooms($hotelRooms)
            ->setSpecialRequests($specialRequests)
            ->setAgencyReferenceNumber($agencyReferenceNumber);
    }
    /**
     * Get NoOfRooms value
     * @return int
     */
    public function getNoOfRooms()
    {
        return $this->NoOfRooms;
    }
    /**
     * Set NoOfRooms value
     * @param int $noOfRooms
     * @return \StructType\HotelBookRequest
     */
    public function setNoOfRooms($noOfRooms = null)
    {
        // validation for constraint: int
        if (!is_null($noOfRooms) && !is_numeric($noOfRooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noOfRooms)), __LINE__);
        }
        $this->NoOfRooms = $noOfRooms;
        return $this;
    }
    /**
     * Get ResultIndex value
     * @return int
     */
    public function getResultIndex()
    {
        return $this->ResultIndex;
    }
    /**
     * Set ResultIndex value
     * @param int $resultIndex
     * @return \StructType\HotelBookRequest
     */
    public function setResultIndex($resultIndex = null)
    {
        // validation for constraint: int
        if (!is_null($resultIndex) && !is_numeric($resultIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultIndex)), __LINE__);
        }
        $this->ResultIndex = $resultIndex;
        return $this;
    }
    /**
     * Get RestrictDuplicateBooking value
     * @return bool
     */
    public function getRestrictDuplicateBooking()
    {
        return $this->RestrictDuplicateBooking;
    }
    /**
     * Set RestrictDuplicateBooking value
     * @param bool $restrictDuplicateBooking
     * @return \StructType\HotelBookRequest
     */
    public function setRestrictDuplicateBooking($restrictDuplicateBooking = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictDuplicateBooking) && !is_bool($restrictDuplicateBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($restrictDuplicateBooking)), __LINE__);
        }
        $this->RestrictDuplicateBooking = $restrictDuplicateBooking;
        return $this;
    }
    /**
     * Get ClientReferenceNumber value
     * @return string|null
     */
    public function getClientReferenceNumber()
    {
        return $this->ClientReferenceNumber;
    }
    /**
     * Set ClientReferenceNumber value
     * @param string $clientReferenceNumber
     * @return \StructType\HotelBookRequest
     */
    public function setClientReferenceNumber($clientReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($clientReferenceNumber) && !is_string($clientReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientReferenceNumber)), __LINE__);
        }
        $this->ClientReferenceNumber = $clientReferenceNumber;
        return $this;
    }
    /**
     * Get GuestNationality value
     * @return string|null
     */
    public function getGuestNationality()
    {
        return $this->GuestNationality;
    }
    /**
     * Set GuestNationality value
     * @param string $guestNationality
     * @return \StructType\HotelBookRequest
     */
    public function setGuestNationality($guestNationality = null)
    {
        // validation for constraint: string
        if (!is_null($guestNationality) && !is_string($guestNationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guestNationality)), __LINE__);
        }
        $this->GuestNationality = $guestNationality;
        return $this;
    }
    /**
     * Get Guests value
     * @return \ArrayType\ArrayOfGuest|null
     */
    public function getGuests()
    {
        return $this->Guests;
    }
    /**
     * Set Guests value
     * @param \ArrayType\ArrayOfGuest $guests
     * @return \StructType\HotelBookRequest
     */
    public function setGuests(\ArrayType\ArrayOfGuest $guests = null)
    {
        $this->Guests = $guests;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return \StructType\AddressInfo|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param \StructType\AddressInfo $addressInfo
     * @return \StructType\HotelBookRequest
     */
    public function setAddressInfo(\StructType\AddressInfo $addressInfo = null)
    {
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \StructType\PaymentInfo|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @param \StructType\PaymentInfo $paymentInfo
     * @return \StructType\HotelBookRequest
     */
    public function setPaymentInfo(\StructType\PaymentInfo $paymentInfo = null)
    {
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get SessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param string $sessionId
     * @return \StructType\HotelBookRequest
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get FlightInfo value
     * @return string|null
     */
    public function getFlightInfo()
    {
        return $this->FlightInfo;
    }
    /**
     * Set FlightInfo value
     * @param string $flightInfo
     * @return \StructType\HotelBookRequest
     */
    public function setFlightInfo($flightInfo = null)
    {
        // validation for constraint: string
        if (!is_null($flightInfo) && !is_string($flightInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightInfo)), __LINE__);
        }
        $this->FlightInfo = $flightInfo;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\HotelBookRequest
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\HotelBookRequest
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelRooms value
     * @return \ArrayType\ArrayOfRequestedRooms|null
     */
    public function getHotelRooms()
    {
        return $this->HotelRooms;
    }
    /**
     * Set HotelRooms value
     * @param \ArrayType\ArrayOfRequestedRooms $hotelRooms
     * @return \StructType\HotelBookRequest
     */
    public function setHotelRooms(\ArrayType\ArrayOfRequestedRooms $hotelRooms = null)
    {
        $this->HotelRooms = $hotelRooms;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \ArrayType\ArrayOfSpecialRequest|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \ArrayType\ArrayOfSpecialRequest $specialRequests
     * @return \StructType\HotelBookRequest
     */
    public function setSpecialRequests(\ArrayType\ArrayOfSpecialRequest $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get AgencyReferenceNumber value
     * @return string|null
     */
    public function getAgencyReferenceNumber()
    {
        return $this->AgencyReferenceNumber;
    }
    /**
     * Set AgencyReferenceNumber value
     * @param string $agencyReferenceNumber
     * @return \StructType\HotelBookRequest
     */
    public function setAgencyReferenceNumber($agencyReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($agencyReferenceNumber) && !is_string($agencyReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencyReferenceNumber)), __LINE__);
        }
        $this->AgencyReferenceNumber = $agencyReferenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelBookRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
