<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guest StructType
 * @subpackage Structs
 */
class Guest extends AbstractStructBase
{
    /**
     * The Age
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Age;
    /**
     * The LeadGuest
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $LeadGuest;
    /**
     * The GuestType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $GuestType;
    /**
     * The GuestInRoom
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $GuestInRoom;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for Guest
     * @uses Guest::setAge()
     * @uses Guest::setLeadGuest()
     * @uses Guest::setGuestType()
     * @uses Guest::setGuestInRoom()
     * @uses Guest::setTitle()
     * @uses Guest::setFirstName()
     * @uses Guest::setLastName()
     * @param int $age
     * @param bool $leadGuest
     * @param string $guestType
     * @param int $guestInRoom
     * @param string $title
     * @param string $firstName
     * @param string $lastName
     */
    public function __construct($age = null, $leadGuest = null, $guestType = null, $guestInRoom = null, $title = null, $firstName = null, $lastName = null)
    {
        $this
            ->setAge($age)
            ->setLeadGuest($leadGuest)
            ->setGuestType($guestType)
            ->setGuestInRoom($guestInRoom)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setLastName($lastName);
    }
    /**
     * Get Age value
     * @return int
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\Guest
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !is_numeric($age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get LeadGuest value
     * @return bool
     */
    public function getLeadGuest()
    {
        return $this->LeadGuest;
    }
    /**
     * Set LeadGuest value
     * @param bool $leadGuest
     * @return \StructType\Guest
     */
    public function setLeadGuest($leadGuest = null)
    {
        // validation for constraint: boolean
        if (!is_null($leadGuest) && !is_bool($leadGuest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($leadGuest)), __LINE__);
        }
        $this->LeadGuest = $leadGuest;
        return $this;
    }
    /**
     * Get GuestType value
     * @return string
     */
    public function getGuestType()
    {
        return $this->GuestType;
    }
    /**
     * Set GuestType value
     * @uses \EnumType\GuestType::valueIsValid()
     * @uses \EnumType\GuestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guestType
     * @return \StructType\Guest
     */
    public function setGuestType($guestType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GuestType::valueIsValid($guestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $guestType, implode(', ', \EnumType\GuestType::getValidValues())), __LINE__);
        }
        $this->GuestType = $guestType;
        return $this;
    }
    /**
     * Get GuestInRoom value
     * @return int
     */
    public function getGuestInRoom()
    {
        return $this->GuestInRoom;
    }
    /**
     * Set GuestInRoom value
     * @param int $guestInRoom
     * @return \StructType\Guest
     */
    public function setGuestInRoom($guestInRoom = null)
    {
        // validation for constraint: int
        if (!is_null($guestInRoom) && !is_numeric($guestInRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($guestInRoom)), __LINE__);
        }
        $this->GuestInRoom = $guestInRoom;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Guest
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Guest
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Guest
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Guest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
