<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiataHotels StructType
 * @subpackage Structs
 */
class GiataHotels extends AbstractStructBase
{
    /**
     * The StarRating
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $StarRating;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * The HotelAddress
     * @var string
     */
    public $HotelAddress;
    /**
     * The Latitude
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * @var string
     */
    public $Longitude;
    /**
     * The CountryName
     * @var string
     */
    public $CountryName;
    /**
     * The CityName
     * @var string
     */
    public $CityName;
    /**
     * Constructor method for GiataHotels
     * @uses GiataHotels::setStarRating()
     * @uses GiataHotels::setHotelCode()
     * @uses GiataHotels::setHotelName()
     * @uses GiataHotels::setHotelAddress()
     * @uses GiataHotels::setLatitude()
     * @uses GiataHotels::setLongitude()
     * @uses GiataHotels::setCountryName()
     * @uses GiataHotels::setCityName()
     * @param string $starRating
     * @param string $hotelCode
     * @param string $hotelName
     * @param string $hotelAddress
     * @param string $latitude
     * @param string $longitude
     * @param string $countryName
     * @param string $cityName
     */
    public function __construct($starRating = null, $hotelCode = null, $hotelName = null, $hotelAddress = null, $latitude = null, $longitude = null, $countryName = null, $cityName = null)
    {
        $this
            ->setStarRating($starRating)
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName)
            ->setHotelAddress($hotelAddress)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setCountryName($countryName)
            ->setCityName($cityName);
    }
    /**
     * Get StarRating value
     * @return string
     */
    public function getStarRating()
    {
        return $this->StarRating;
    }
    /**
     * Set StarRating value
     * @uses \EnumType\HotelRating::valueIsValid()
     * @uses \EnumType\HotelRating::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $starRating
     * @return \StructType\GiataHotels
     */
    public function setStarRating($starRating = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelRating::valueIsValid($starRating)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $starRating, implode(', ', \EnumType\HotelRating::getValidValues())), __LINE__);
        }
        $this->StarRating = $starRating;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\GiataHotels
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\GiataHotels
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelAddress value
     * @return string|null
     */
    public function getHotelAddress()
    {
        return $this->HotelAddress;
    }
    /**
     * Set HotelAddress value
     * @param string $hotelAddress
     * @return \StructType\GiataHotels
     */
    public function setHotelAddress($hotelAddress = null)
    {
        // validation for constraint: string
        if (!is_null($hotelAddress) && !is_string($hotelAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelAddress)), __LINE__);
        }
        $this->HotelAddress = $hotelAddress;
        return $this;
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \StructType\GiataHotels
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \StructType\GiataHotels
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \StructType\GiataHotels
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\GiataHotels
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GiataHotels
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
