<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateInvoiceResponse StructType
 * @subpackage Structs
 */
class GenerateInvoiceResponse extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseStatus
     */
    public $Status;
    /**
     * The BookingId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingId;
    /**
     * The InvoiceNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNo;
    /**
     * Constructor method for GenerateInvoiceResponse
     * @uses GenerateInvoiceResponse::setStatus()
     * @uses GenerateInvoiceResponse::setBookingId()
     * @uses GenerateInvoiceResponse::setInvoiceNo()
     * @param \StructType\ResponseStatus $status
     * @param string $bookingId
     * @param string $invoiceNo
     */
    public function __construct(\StructType\ResponseStatus $status = null, $bookingId = null, $invoiceNo = null)
    {
        $this
            ->setStatus($status)
            ->setBookingId($bookingId)
            ->setInvoiceNo($invoiceNo);
    }
    /**
     * Get Status value
     * @return \StructType\ResponseStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\ResponseStatus $status
     * @return \StructType\GenerateInvoiceResponse
     */
    public function setStatus(\StructType\ResponseStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get BookingId value
     * @return string|null
     */
    public function getBookingId()
    {
        return $this->BookingId;
    }
    /**
     * Set BookingId value
     * @param string $bookingId
     * @return \StructType\GenerateInvoiceResponse
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: string
        if (!is_null($bookingId) && !is_string($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingId)), __LINE__);
        }
        $this->BookingId = $bookingId;
        return $this;
    }
    /**
     * Get InvoiceNo value
     * @return string|null
     */
    public function getInvoiceNo()
    {
        return $this->InvoiceNo;
    }
    /**
     * Set InvoiceNo value
     * @param string $invoiceNo
     * @return \StructType\GenerateInvoiceResponse
     */
    public function setInvoiceNo($invoiceNo = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNo) && !is_string($invoiceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceNo)), __LINE__);
        }
        $this->InvoiceNo = $invoiceNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenerateInvoiceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
