<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Filters StructType
 * @subpackage Structs
 */
class Filters extends AbstractStructBase
{
    /**
     * The StarRating
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StarRating;
    /**
     * The OrderBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderBy;
    /**
     * The HotelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelName;
    /**
     * The HotelCodeList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelCodeList;
    /**
     * Constructor method for Filters
     * @uses Filters::setStarRating()
     * @uses Filters::setOrderBy()
     * @uses Filters::setHotelName()
     * @uses Filters::setHotelCodeList()
     * @param string $starRating
     * @param string $orderBy
     * @param string $hotelName
     * @param string $hotelCodeList
     */
    public function __construct($starRating = null, $orderBy = null, $hotelName = null, $hotelCodeList = null)
    {
        $this
            ->setStarRating($starRating)
            ->setOrderBy($orderBy)
            ->setHotelName($hotelName)
            ->setHotelCodeList($hotelCodeList);
    }
    /**
     * Get StarRating value
     * @return string
     */
    public function getStarRating()
    {
        return $this->StarRating;
    }
    /**
     * Set StarRating value
     * @uses \EnumType\HotelRatingInput::valueIsValid()
     * @uses \EnumType\HotelRatingInput::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $starRating
     * @return \StructType\Filters
     */
    public function setStarRating($starRating = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelRatingInput::valueIsValid($starRating)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $starRating, implode(', ', \EnumType\HotelRatingInput::getValidValues())), __LINE__);
        }
        $this->StarRating = $starRating;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @uses \EnumType\OrderByFilter::valueIsValid()
     * @uses \EnumType\OrderByFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderBy
     * @return \StructType\Filters
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderByFilter::valueIsValid($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderBy, implode(', ', \EnumType\OrderByFilter::getValidValues())), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\Filters
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelCodeList value
     * @return string|null
     */
    public function getHotelCodeList()
    {
        return $this->HotelCodeList;
    }
    /**
     * Set HotelCodeList value
     * @param string $hotelCodeList
     * @return \StructType\Filters
     */
    public function setHotelCodeList($hotelCodeList = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeList) && !is_string($hotelCodeList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCodeList)), __LINE__);
        }
        $this->HotelCodeList = $hotelCodeList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Filters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
