<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationCityListRequest StructType
 * @subpackage Structs
 */
class DestinationCityListRequest extends AbstractStructBase
{
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The ReturnNewCityCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnNewCityCodes;
    /**
     * Constructor method for DestinationCityListRequest
     * @uses DestinationCityListRequest::setCountryCode()
     * @uses DestinationCityListRequest::setReturnNewCityCodes()
     * @param string $countryCode
     * @param string $returnNewCityCodes
     */
    public function __construct($countryCode = null, $returnNewCityCodes = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setReturnNewCityCodes($returnNewCityCodes);
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\DestinationCityListRequest
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get ReturnNewCityCodes value
     * @return string|null
     */
    public function getReturnNewCityCodes()
    {
        return $this->ReturnNewCityCodes;
    }
    /**
     * Set ReturnNewCityCodes value
     * @param string $returnNewCityCodes
     * @return \StructType\DestinationCityListRequest
     */
    public function setReturnNewCityCodes($returnNewCityCodes = null)
    {
        // validation for constraint: string
        if (!is_null($returnNewCityCodes) && !is_string($returnNewCityCodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnNewCityCodes)), __LINE__);
        }
        $this->ReturnNewCityCodes = $returnNewCityCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DestinationCityListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
