<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPolicy StructType
 * @subpackage Structs
 */
class CancelPolicy extends AbstractStructBase
{
    /**
     * The ChargeType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ChargeType;
    /**
     * The CancellationCharge
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $CancellationCharge;
    /**
     * The RoomTypeName
     * @var string
     */
    public $RoomTypeName;
    /**
     * The RoomIndex
     * @var string
     */
    public $RoomIndex;
    /**
     * The FromDate
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * @var string
     */
    public $ToDate;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The PrefCurrency
     * @var string
     */
    public $PrefCurrency;
    /**
     * The PrefCancellationCharge
     * @var string
     */
    public $PrefCancellationCharge;
    /**
     * Constructor method for CancelPolicy
     * @uses CancelPolicy::setChargeType()
     * @uses CancelPolicy::setCancellationCharge()
     * @uses CancelPolicy::setRoomTypeName()
     * @uses CancelPolicy::setRoomIndex()
     * @uses CancelPolicy::setFromDate()
     * @uses CancelPolicy::setToDate()
     * @uses CancelPolicy::setCurrency()
     * @uses CancelPolicy::setPrefCurrency()
     * @uses CancelPolicy::setPrefCancellationCharge()
     * @param string $chargeType
     * @param float $cancellationCharge
     * @param string $roomTypeName
     * @param string $roomIndex
     * @param string $fromDate
     * @param string $toDate
     * @param string $currency
     * @param string $prefCurrency
     * @param string $prefCancellationCharge
     */
    public function __construct($chargeType = null, $cancellationCharge = null, $roomTypeName = null, $roomIndex = null, $fromDate = null, $toDate = null, $currency = null, $prefCurrency = null, $prefCancellationCharge = null)
    {
        $this
            ->setChargeType($chargeType)
            ->setCancellationCharge($cancellationCharge)
            ->setRoomTypeName($roomTypeName)
            ->setRoomIndex($roomIndex)
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setCurrency($currency)
            ->setPrefCurrency($prefCurrency)
            ->setPrefCancellationCharge($prefCancellationCharge);
    }
    /**
     * Get ChargeType value
     * @return string
     */
    public function getChargeType()
    {
        return $this->ChargeType;
    }
    /**
     * Set ChargeType value
     * @uses \EnumType\CancellationChargeTypeForHotel::valueIsValid()
     * @uses \EnumType\CancellationChargeTypeForHotel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chargeType
     * @return \StructType\CancelPolicy
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CancellationChargeTypeForHotel::valueIsValid($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $chargeType, implode(', ', \EnumType\CancellationChargeTypeForHotel::getValidValues())), __LINE__);
        }
        $this->ChargeType = $chargeType;
        return $this;
    }
    /**
     * Get CancellationCharge value
     * @return float
     */
    public function getCancellationCharge()
    {
        return $this->CancellationCharge;
    }
    /**
     * Set CancellationCharge value
     * @param float $cancellationCharge
     * @return \StructType\CancelPolicy
     */
    public function setCancellationCharge($cancellationCharge = null)
    {
        $this->CancellationCharge = $cancellationCharge;
        return $this;
    }
    /**
     * Get RoomTypeName value
     * @return string|null
     */
    public function getRoomTypeName()
    {
        return $this->RoomTypeName;
    }
    /**
     * Set RoomTypeName value
     * @param string $roomTypeName
     * @return \StructType\CancelPolicy
     */
    public function setRoomTypeName($roomTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeName) && !is_string($roomTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeName)), __LINE__);
        }
        $this->RoomTypeName = $roomTypeName;
        return $this;
    }
    /**
     * Get RoomIndex value
     * @return string|null
     */
    public function getRoomIndex()
    {
        return $this->RoomIndex;
    }
    /**
     * Set RoomIndex value
     * @param string $roomIndex
     * @return \StructType\CancelPolicy
     */
    public function setRoomIndex($roomIndex = null)
    {
        // validation for constraint: string
        if (!is_null($roomIndex) && !is_string($roomIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomIndex)), __LINE__);
        }
        $this->RoomIndex = $roomIndex;
        return $this;
    }
    /**
     * Get FromDate value
     * @return string|null
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \StructType\CancelPolicy
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDate)), __LINE__);
        }
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string|null
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \StructType\CancelPolicy
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDate)), __LINE__);
        }
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\CancelPolicy
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get PrefCurrency value
     * @return string|null
     */
    public function getPrefCurrency()
    {
        return $this->PrefCurrency;
    }
    /**
     * Set PrefCurrency value
     * @param string $prefCurrency
     * @return \StructType\CancelPolicy
     */
    public function setPrefCurrency($prefCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($prefCurrency) && !is_string($prefCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefCurrency)), __LINE__);
        }
        $this->PrefCurrency = $prefCurrency;
        return $this;
    }
    /**
     * Get PrefCancellationCharge value
     * @return string|null
     */
    public function getPrefCancellationCharge()
    {
        return $this->PrefCancellationCharge;
    }
    /**
     * Set PrefCancellationCharge value
     * @param string $prefCancellationCharge
     * @return \StructType\CancelPolicy
     */
    public function setPrefCancellationCharge($prefCancellationCharge = null)
    {
        // validation for constraint: string
        if (!is_null($prefCancellationCharge) && !is_string($prefCancellationCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefCancellationCharge)), __LINE__);
        }
        $this->PrefCancellationCharge = $prefCancellationCharge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
