<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPolicies StructType
 * @subpackage Structs
 */
class CancelPolicies extends AbstractStructBase
{
    /**
     * The LastCancellationDeadline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastCancellationDeadline;
    /**
     * The PolicyFormat
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PolicyFormat;
    /**
     * The CancelPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelPolicy[]
     */
    public $CancelPolicy;
    /**
     * The TextPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TextPolicy;
    /**
     * The NoShowPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelPolicy[]
     */
    public $NoShowPolicy;
    /**
     * The DefaultPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultPolicy;
    /**
     * The AutoCancellationText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoCancellationText;
    /**
     * Constructor method for CancelPolicies
     * @uses CancelPolicies::setLastCancellationDeadline()
     * @uses CancelPolicies::setPolicyFormat()
     * @uses CancelPolicies::setCancelPolicy()
     * @uses CancelPolicies::setTextPolicy()
     * @uses CancelPolicies::setNoShowPolicy()
     * @uses CancelPolicies::setDefaultPolicy()
     * @uses CancelPolicies::setAutoCancellationText()
     * @param string $lastCancellationDeadline
     * @param string $policyFormat
     * @param \StructType\CancelPolicy[] $cancelPolicy
     * @param string[] $textPolicy
     * @param \StructType\CancelPolicy[] $noShowPolicy
     * @param string $defaultPolicy
     * @param string $autoCancellationText
     */
    public function __construct($lastCancellationDeadline = null, $policyFormat = null, array $cancelPolicy = array(), array $textPolicy = array(), array $noShowPolicy = array(), $defaultPolicy = null, $autoCancellationText = null)
    {
        $this
            ->setLastCancellationDeadline($lastCancellationDeadline)
            ->setPolicyFormat($policyFormat)
            ->setCancelPolicy($cancelPolicy)
            ->setTextPolicy($textPolicy)
            ->setNoShowPolicy($noShowPolicy)
            ->setDefaultPolicy($defaultPolicy)
            ->setAutoCancellationText($autoCancellationText);
    }
    /**
     * Get LastCancellationDeadline value
     * @return string
     */
    public function getLastCancellationDeadline()
    {
        return $this->LastCancellationDeadline;
    }
    /**
     * Set LastCancellationDeadline value
     * @param string $lastCancellationDeadline
     * @return \StructType\CancelPolicies
     */
    public function setLastCancellationDeadline($lastCancellationDeadline = null)
    {
        // validation for constraint: string
        if (!is_null($lastCancellationDeadline) && !is_string($lastCancellationDeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastCancellationDeadline)), __LINE__);
        }
        $this->LastCancellationDeadline = $lastCancellationDeadline;
        return $this;
    }
    /**
     * Get PolicyFormat value
     * @return string
     */
    public function getPolicyFormat()
    {
        return $this->PolicyFormat;
    }
    /**
     * Set PolicyFormat value
     * @uses \EnumType\PolicyFormat::valueIsValid()
     * @uses \EnumType\PolicyFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policyFormat
     * @return \StructType\CancelPolicies
     */
    public function setPolicyFormat($policyFormat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PolicyFormat::valueIsValid($policyFormat)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $policyFormat, implode(', ', \EnumType\PolicyFormat::getValidValues())), __LINE__);
        }
        $this->PolicyFormat = $policyFormat;
        return $this;
    }
    /**
     * Get CancelPolicy value
     * @return \StructType\CancelPolicy[]|null
     */
    public function getCancelPolicy()
    {
        return $this->CancelPolicy;
    }
    /**
     * Set CancelPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelPolicy[] $cancelPolicy
     * @return \StructType\CancelPolicies
     */
    public function setCancelPolicy(array $cancelPolicy = array())
    {
        foreach ($cancelPolicy as $cancelPoliciesCancelPolicyItem) {
            // validation for constraint: itemType
            if (!$cancelPoliciesCancelPolicyItem instanceof \StructType\CancelPolicy) {
                throw new \InvalidArgumentException(sprintf('The CancelPolicy property can only contain items of \StructType\CancelPolicy, "%s" given', is_object($cancelPoliciesCancelPolicyItem) ? get_class($cancelPoliciesCancelPolicyItem) : gettype($cancelPoliciesCancelPolicyItem)), __LINE__);
            }
        }
        $this->CancelPolicy = $cancelPolicy;
        return $this;
    }
    /**
     * Add item to CancelPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelPolicy $item
     * @return \StructType\CancelPolicies
     */
    public function addToCancelPolicy(\StructType\CancelPolicy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelPolicy) {
            throw new \InvalidArgumentException(sprintf('The CancelPolicy property can only contain items of \StructType\CancelPolicy, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CancelPolicy[] = $item;
        return $this;
    }
    /**
     * Get TextPolicy value
     * @return string[]|null
     */
    public function getTextPolicy()
    {
        return $this->TextPolicy;
    }
    /**
     * Set TextPolicy value
     * @throws \InvalidArgumentException
     * @param string[] $textPolicy
     * @return \StructType\CancelPolicies
     */
    public function setTextPolicy(array $textPolicy = array())
    {
        foreach ($textPolicy as $cancelPoliciesTextPolicyItem) {
            // validation for constraint: itemType
            if (!is_string($cancelPoliciesTextPolicyItem)) {
                throw new \InvalidArgumentException(sprintf('The TextPolicy property can only contain items of string, "%s" given', is_object($cancelPoliciesTextPolicyItem) ? get_class($cancelPoliciesTextPolicyItem) : gettype($cancelPoliciesTextPolicyItem)), __LINE__);
            }
        }
        $this->TextPolicy = $textPolicy;
        return $this;
    }
    /**
     * Add item to TextPolicy value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CancelPolicies
     */
    public function addToTextPolicy($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TextPolicy property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TextPolicy[] = $item;
        return $this;
    }
    /**
     * Get NoShowPolicy value
     * @return \StructType\CancelPolicy[]|null
     */
    public function getNoShowPolicy()
    {
        return $this->NoShowPolicy;
    }
    /**
     * Set NoShowPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelPolicy[] $noShowPolicy
     * @return \StructType\CancelPolicies
     */
    public function setNoShowPolicy(array $noShowPolicy = array())
    {
        foreach ($noShowPolicy as $cancelPoliciesNoShowPolicyItem) {
            // validation for constraint: itemType
            if (!$cancelPoliciesNoShowPolicyItem instanceof \StructType\CancelPolicy) {
                throw new \InvalidArgumentException(sprintf('The NoShowPolicy property can only contain items of \StructType\CancelPolicy, "%s" given', is_object($cancelPoliciesNoShowPolicyItem) ? get_class($cancelPoliciesNoShowPolicyItem) : gettype($cancelPoliciesNoShowPolicyItem)), __LINE__);
            }
        }
        $this->NoShowPolicy = $noShowPolicy;
        return $this;
    }
    /**
     * Add item to NoShowPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelPolicy $item
     * @return \StructType\CancelPolicies
     */
    public function addToNoShowPolicy(\StructType\CancelPolicy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelPolicy) {
            throw new \InvalidArgumentException(sprintf('The NoShowPolicy property can only contain items of \StructType\CancelPolicy, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NoShowPolicy[] = $item;
        return $this;
    }
    /**
     * Get DefaultPolicy value
     * @return string|null
     */
    public function getDefaultPolicy()
    {
        return $this->DefaultPolicy;
    }
    /**
     * Set DefaultPolicy value
     * @param string $defaultPolicy
     * @return \StructType\CancelPolicies
     */
    public function setDefaultPolicy($defaultPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($defaultPolicy) && !is_string($defaultPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultPolicy)), __LINE__);
        }
        $this->DefaultPolicy = $defaultPolicy;
        return $this;
    }
    /**
     * Get AutoCancellationText value
     * @return string|null
     */
    public function getAutoCancellationText()
    {
        return $this->AutoCancellationText;
    }
    /**
     * Set AutoCancellationText value
     * @param string $autoCancellationText
     * @return \StructType\CancelPolicies
     */
    public function setAutoCancellationText($autoCancellationText = null)
    {
        // validation for constraint: string
        if (!is_null($autoCancellationText) && !is_string($autoCancellationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoCancellationText)), __LINE__);
        }
        $this->AutoCancellationText = $autoCancellationText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelPolicies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
