<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingsBasedOnDate StructType
 * @subpackage Structs
 */
class BookingsBasedOnDate extends AbstractStructBase
{
    /**
     * The Index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Index;
    /**
     * The BookingStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BookingStatus;
    /**
     * The BookingId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingId;
    /**
     * The ConfirmationNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNo;
    /**
     * The BookingDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingDate;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The AgentMarkup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentMarkup;
    /**
     * The AgencyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyName;
    /**
     * The BookingPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingPrice;
    /**
     * The Remarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Remarks;
    /**
     * Constructor method for BookingsBasedOnDate
     * @uses BookingsBasedOnDate::setIndex()
     * @uses BookingsBasedOnDate::setBookingStatus()
     * @uses BookingsBasedOnDate::setBookingId()
     * @uses BookingsBasedOnDate::setConfirmationNo()
     * @uses BookingsBasedOnDate::setBookingDate()
     * @uses BookingsBasedOnDate::setCurrency()
     * @uses BookingsBasedOnDate::setAgentMarkup()
     * @uses BookingsBasedOnDate::setAgencyName()
     * @uses BookingsBasedOnDate::setBookingPrice()
     * @uses BookingsBasedOnDate::setRemarks()
     * @param int $index
     * @param string $bookingStatus
     * @param string $bookingId
     * @param string $confirmationNo
     * @param string $bookingDate
     * @param string $currency
     * @param string $agentMarkup
     * @param string $agencyName
     * @param string $bookingPrice
     * @param string $remarks
     */
    public function __construct($index = null, $bookingStatus = null, $bookingId = null, $confirmationNo = null, $bookingDate = null, $currency = null, $agentMarkup = null, $agencyName = null, $bookingPrice = null, $remarks = null)
    {
        $this
            ->setIndex($index)
            ->setBookingStatus($bookingStatus)
            ->setBookingId($bookingId)
            ->setConfirmationNo($confirmationNo)
            ->setBookingDate($bookingDate)
            ->setCurrency($currency)
            ->setAgentMarkup($agentMarkup)
            ->setAgencyName($agencyName)
            ->setBookingPrice($bookingPrice)
            ->setRemarks($remarks);
    }
    /**
     * Get Index value
     * @return int
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * Set Index value
     * @param int $index
     * @return \StructType\BookingsBasedOnDate
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !is_numeric($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($index)), __LINE__);
        }
        $this->Index = $index;
        return $this;
    }
    /**
     * Get BookingStatus value
     * @return string
     */
    public function getBookingStatus()
    {
        return $this->BookingStatus;
    }
    /**
     * Set BookingStatus value
     * @uses \EnumType\APIHotelBookingStatus::valueIsValid()
     * @uses \EnumType\APIHotelBookingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingStatus
     * @return \StructType\BookingsBasedOnDate
     */
    public function setBookingStatus($bookingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\APIHotelBookingStatus::valueIsValid($bookingStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bookingStatus, implode(', ', \EnumType\APIHotelBookingStatus::getValidValues())), __LINE__);
        }
        $this->BookingStatus = $bookingStatus;
        return $this;
    }
    /**
     * Get BookingId value
     * @return string|null
     */
    public function getBookingId()
    {
        return $this->BookingId;
    }
    /**
     * Set BookingId value
     * @param string $bookingId
     * @return \StructType\BookingsBasedOnDate
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: string
        if (!is_null($bookingId) && !is_string($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingId)), __LINE__);
        }
        $this->BookingId = $bookingId;
        return $this;
    }
    /**
     * Get ConfirmationNo value
     * @return string|null
     */
    public function getConfirmationNo()
    {
        return $this->ConfirmationNo;
    }
    /**
     * Set ConfirmationNo value
     * @param string $confirmationNo
     * @return \StructType\BookingsBasedOnDate
     */
    public function setConfirmationNo($confirmationNo = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNo) && !is_string($confirmationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confirmationNo)), __LINE__);
        }
        $this->ConfirmationNo = $confirmationNo;
        return $this;
    }
    /**
     * Get BookingDate value
     * @return string|null
     */
    public function getBookingDate()
    {
        return $this->BookingDate;
    }
    /**
     * Set BookingDate value
     * @param string $bookingDate
     * @return \StructType\BookingsBasedOnDate
     */
    public function setBookingDate($bookingDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDate) && !is_string($bookingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingDate)), __LINE__);
        }
        $this->BookingDate = $bookingDate;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\BookingsBasedOnDate
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get AgentMarkup value
     * @return string|null
     */
    public function getAgentMarkup()
    {
        return $this->AgentMarkup;
    }
    /**
     * Set AgentMarkup value
     * @param string $agentMarkup
     * @return \StructType\BookingsBasedOnDate
     */
    public function setAgentMarkup($agentMarkup = null)
    {
        // validation for constraint: string
        if (!is_null($agentMarkup) && !is_string($agentMarkup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentMarkup)), __LINE__);
        }
        $this->AgentMarkup = $agentMarkup;
        return $this;
    }
    /**
     * Get AgencyName value
     * @return string|null
     */
    public function getAgencyName()
    {
        return $this->AgencyName;
    }
    /**
     * Set AgencyName value
     * @param string $agencyName
     * @return \StructType\BookingsBasedOnDate
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencyName)), __LINE__);
        }
        $this->AgencyName = $agencyName;
        return $this;
    }
    /**
     * Get BookingPrice value
     * @return string|null
     */
    public function getBookingPrice()
    {
        return $this->BookingPrice;
    }
    /**
     * Set BookingPrice value
     * @param string $bookingPrice
     * @return \StructType\BookingsBasedOnDate
     */
    public function setBookingPrice($bookingPrice = null)
    {
        // validation for constraint: string
        if (!is_null($bookingPrice) && !is_string($bookingPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingPrice)), __LINE__);
        }
        $this->BookingPrice = $bookingPrice;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\BookingsBasedOnDate
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingsBasedOnDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
