<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmendmentResponse StructType
 * @subpackage Structs
 */
class AmendmentResponse extends AbstractStructBase
{
    /**
     * The RequestStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RequestStatus;
    /**
     * The BookingId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BookingId;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseStatus
     */
    public $Status;
    /**
     * The ApprovalInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApprovalInformation
     */
    public $ApprovalInformation;
    /**
     * The NewConfirmatioNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewConfirmatioNo;
    /**
     * The NewLastCancellationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewLastCancellationDate;
    /**
     * The AmendmentMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AmendmentMessage;
    /**
     * The AmendmentRequested
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmendmentRequested
     */
    public $AmendmentRequested;
    /**
     * Constructor method for AmendmentResponse
     * @uses AmendmentResponse::setRequestStatus()
     * @uses AmendmentResponse::setBookingId()
     * @uses AmendmentResponse::setStatus()
     * @uses AmendmentResponse::setApprovalInformation()
     * @uses AmendmentResponse::setNewConfirmatioNo()
     * @uses AmendmentResponse::setNewLastCancellationDate()
     * @uses AmendmentResponse::setAmendmentMessage()
     * @uses AmendmentResponse::setAmendmentRequested()
     * @param string $requestStatus
     * @param int $bookingId
     * @param \StructType\ResponseStatus $status
     * @param \StructType\ApprovalInformation $approvalInformation
     * @param string $newConfirmatioNo
     * @param string $newLastCancellationDate
     * @param string $amendmentMessage
     * @param \StructType\AmendmentRequested $amendmentRequested
     */
    public function __construct($requestStatus = null, $bookingId = null, \StructType\ResponseStatus $status = null, \StructType\ApprovalInformation $approvalInformation = null, $newConfirmatioNo = null, $newLastCancellationDate = null, $amendmentMessage = null, \StructType\AmendmentRequested $amendmentRequested = null)
    {
        $this
            ->setRequestStatus($requestStatus)
            ->setBookingId($bookingId)
            ->setStatus($status)
            ->setApprovalInformation($approvalInformation)
            ->setNewConfirmatioNo($newConfirmatioNo)
            ->setNewLastCancellationDate($newLastCancellationDate)
            ->setAmendmentMessage($amendmentMessage)
            ->setAmendmentRequested($amendmentRequested);
    }
    /**
     * Get RequestStatus value
     * @return string
     */
    public function getRequestStatus()
    {
        return $this->RequestStatus;
    }
    /**
     * Set RequestStatus value
     * @uses \EnumType\RequestStatus::valueIsValid()
     * @uses \EnumType\RequestStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestStatus
     * @return \StructType\AmendmentResponse
     */
    public function setRequestStatus($requestStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RequestStatus::valueIsValid($requestStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestStatus, implode(', ', \EnumType\RequestStatus::getValidValues())), __LINE__);
        }
        $this->RequestStatus = $requestStatus;
        return $this;
    }
    /**
     * Get BookingId value
     * @return int
     */
    public function getBookingId()
    {
        return $this->BookingId;
    }
    /**
     * Set BookingId value
     * @param int $bookingId
     * @return \StructType\AmendmentResponse
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: int
        if (!is_null($bookingId) && !is_numeric($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bookingId)), __LINE__);
        }
        $this->BookingId = $bookingId;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\ResponseStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\ResponseStatus $status
     * @return \StructType\AmendmentResponse
     */
    public function setStatus(\StructType\ResponseStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ApprovalInformation value
     * @return \StructType\ApprovalInformation|null
     */
    public function getApprovalInformation()
    {
        return $this->ApprovalInformation;
    }
    /**
     * Set ApprovalInformation value
     * @param \StructType\ApprovalInformation $approvalInformation
     * @return \StructType\AmendmentResponse
     */
    public function setApprovalInformation(\StructType\ApprovalInformation $approvalInformation = null)
    {
        $this->ApprovalInformation = $approvalInformation;
        return $this;
    }
    /**
     * Get NewConfirmatioNo value
     * @return string|null
     */
    public function getNewConfirmatioNo()
    {
        return $this->NewConfirmatioNo;
    }
    /**
     * Set NewConfirmatioNo value
     * @param string $newConfirmatioNo
     * @return \StructType\AmendmentResponse
     */
    public function setNewConfirmatioNo($newConfirmatioNo = null)
    {
        // validation for constraint: string
        if (!is_null($newConfirmatioNo) && !is_string($newConfirmatioNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newConfirmatioNo)), __LINE__);
        }
        $this->NewConfirmatioNo = $newConfirmatioNo;
        return $this;
    }
    /**
     * Get NewLastCancellationDate value
     * @return string|null
     */
    public function getNewLastCancellationDate()
    {
        return $this->NewLastCancellationDate;
    }
    /**
     * Set NewLastCancellationDate value
     * @param string $newLastCancellationDate
     * @return \StructType\AmendmentResponse
     */
    public function setNewLastCancellationDate($newLastCancellationDate = null)
    {
        // validation for constraint: string
        if (!is_null($newLastCancellationDate) && !is_string($newLastCancellationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newLastCancellationDate)), __LINE__);
        }
        $this->NewLastCancellationDate = $newLastCancellationDate;
        return $this;
    }
    /**
     * Get AmendmentMessage value
     * @return string|null
     */
    public function getAmendmentMessage()
    {
        return $this->AmendmentMessage;
    }
    /**
     * Set AmendmentMessage value
     * @param string $amendmentMessage
     * @return \StructType\AmendmentResponse
     */
    public function setAmendmentMessage($amendmentMessage = null)
    {
        // validation for constraint: string
        if (!is_null($amendmentMessage) && !is_string($amendmentMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($amendmentMessage)), __LINE__);
        }
        $this->AmendmentMessage = $amendmentMessage;
        return $this;
    }
    /**
     * Get AmendmentRequested value
     * @return \StructType\AmendmentRequested|null
     */
    public function getAmendmentRequested()
    {
        return $this->AmendmentRequested;
    }
    /**
     * Set AmendmentRequested value
     * @param \StructType\AmendmentRequested $amendmentRequested
     * @return \StructType\AmendmentResponse
     */
    public function setAmendmentRequested(\StructType\AmendmentRequested $amendmentRequested = null)
    {
        $this->AmendmentRequested = $amendmentRequested;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AmendmentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
