<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmendmentRequestType StructType
 * @subpackage Structs
 */
class AmendmentRequestType extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The PriceChange
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PriceChange;
    /**
     * The Remarks
     * @var string
     */
    public $Remarks;
    /**
     * Constructor method for AmendmentRequestType
     * @uses AmendmentRequestType::setType()
     * @uses AmendmentRequestType::setPriceChange()
     * @uses AmendmentRequestType::setRemarks()
     * @param string $type
     * @param string $priceChange
     * @param string $remarks
     */
    public function __construct($type = null, $priceChange = null, $remarks = null)
    {
        $this
            ->setType($type)
            ->setPriceChange($priceChange)
            ->setRemarks($remarks);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\AmendmentType::valueIsValid()
     * @uses \EnumType\AmendmentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\AmendmentRequestType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AmendmentType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\AmendmentType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PriceChange value
     * @return string
     */
    public function getPriceChange()
    {
        return $this->PriceChange;
    }
    /**
     * Set PriceChange value
     * @uses \EnumType\PriceChange::valueIsValid()
     * @uses \EnumType\PriceChange::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceChange
     * @return \StructType\AmendmentRequestType
     */
    public function setPriceChange($priceChange = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PriceChange::valueIsValid($priceChange)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priceChange, implode(', ', \EnumType\PriceChange::getValidValues())), __LINE__);
        }
        $this->PriceChange = $priceChange;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\AmendmentRequestType
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AmendmentRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
