<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmendmentRequest StructType
 * @subpackage Structs
 */
class AmendmentRequest extends AbstractStructBase
{
    /**
     * The BookingId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BookingId;
    /**
     * The Request
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmendmentRequestType
     */
    public $Request;
    /**
     * The AmendInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmendInformation
     */
    public $AmendInformation;
    /**
     * The ConfirmationNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNo;
    /**
     * Constructor method for AmendmentRequest
     * @uses AmendmentRequest::setBookingId()
     * @uses AmendmentRequest::setRequest()
     * @uses AmendmentRequest::setAmendInformation()
     * @uses AmendmentRequest::setConfirmationNo()
     * @param int $bookingId
     * @param \StructType\AmendmentRequestType $request
     * @param \StructType\AmendInformation $amendInformation
     * @param string $confirmationNo
     */
    public function __construct($bookingId = null, \StructType\AmendmentRequestType $request = null, \StructType\AmendInformation $amendInformation = null, $confirmationNo = null)
    {
        $this
            ->setBookingId($bookingId)
            ->setRequest($request)
            ->setAmendInformation($amendInformation)
            ->setConfirmationNo($confirmationNo);
    }
    /**
     * Get BookingId value
     * @return int
     */
    public function getBookingId()
    {
        return $this->BookingId;
    }
    /**
     * Set BookingId value
     * @param int $bookingId
     * @return \StructType\AmendmentRequest
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: int
        if (!is_null($bookingId) && !is_numeric($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bookingId)), __LINE__);
        }
        $this->BookingId = $bookingId;
        return $this;
    }
    /**
     * Get Request value
     * @return \StructType\AmendmentRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \StructType\AmendmentRequestType $request
     * @return \StructType\AmendmentRequest
     */
    public function setRequest(\StructType\AmendmentRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get AmendInformation value
     * @return \StructType\AmendInformation|null
     */
    public function getAmendInformation()
    {
        return $this->AmendInformation;
    }
    /**
     * Set AmendInformation value
     * @param \StructType\AmendInformation $amendInformation
     * @return \StructType\AmendmentRequest
     */
    public function setAmendInformation(\StructType\AmendInformation $amendInformation = null)
    {
        $this->AmendInformation = $amendInformation;
        return $this;
    }
    /**
     * Get ConfirmationNo value
     * @return string|null
     */
    public function getConfirmationNo()
    {
        return $this->ConfirmationNo;
    }
    /**
     * Set ConfirmationNo value
     * @param string $confirmationNo
     * @return \StructType\AmendmentRequest
     */
    public function setConfirmationNo($confirmationNo = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNo) && !is_string($confirmationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confirmationNo)), __LINE__);
        }
        $this->ConfirmationNo = $confirmationNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AmendmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
