<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmendGuestReq StructType
 * @subpackage Structs
 */
class AmendGuestReq extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Action;
    /**
     * The GuestType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $GuestType;
    /**
     * The Age
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Age;
    /**
     * The ExistingName
     * @var string
     */
    public $ExistingName;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for AmendGuestReq
     * @uses AmendGuestReq::setAction()
     * @uses AmendGuestReq::setGuestType()
     * @uses AmendGuestReq::setAge()
     * @uses AmendGuestReq::setExistingName()
     * @uses AmendGuestReq::setTitle()
     * @uses AmendGuestReq::setFirstName()
     * @uses AmendGuestReq::setLastName()
     * @param string $action
     * @param string $guestType
     * @param int $age
     * @param string $existingName
     * @param string $title
     * @param string $firstName
     * @param string $lastName
     */
    public function __construct($action = null, $guestType = null, $age = null, $existingName = null, $title = null, $firstName = null, $lastName = null)
    {
        $this
            ->setAction($action)
            ->setGuestType($guestType)
            ->setAge($age)
            ->setExistingName($existingName)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setLastName($lastName);
    }
    /**
     * Get Action value
     * @return string
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\AmendActionReq::valueIsValid()
     * @uses \EnumType\AmendActionReq::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\AmendGuestReq
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AmendActionReq::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\AmendActionReq::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get GuestType value
     * @return string
     */
    public function getGuestType()
    {
        return $this->GuestType;
    }
    /**
     * Set GuestType value
     * @uses \EnumType\GuestType::valueIsValid()
     * @uses \EnumType\GuestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guestType
     * @return \StructType\AmendGuestReq
     */
    public function setGuestType($guestType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GuestType::valueIsValid($guestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $guestType, implode(', ', \EnumType\GuestType::getValidValues())), __LINE__);
        }
        $this->GuestType = $guestType;
        return $this;
    }
    /**
     * Get Age value
     * @return int
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\AmendGuestReq
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !is_numeric($age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get ExistingName value
     * @return string|null
     */
    public function getExistingName()
    {
        return $this->ExistingName;
    }
    /**
     * Set ExistingName value
     * @param string $existingName
     * @return \StructType\AmendGuestReq
     */
    public function setExistingName($existingName = null)
    {
        // validation for constraint: string
        if (!is_null($existingName) && !is_string($existingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($existingName)), __LINE__);
        }
        $this->ExistingName = $existingName;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\AmendGuestReq
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\AmendGuestReq
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\AmendGuestReq
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AmendGuestReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
