<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgencyDetails StructType
 * @subpackage Structs
 */
class AgencyDetails extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The AddressLine1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine2;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The PIN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN;
    /**
     * The OfficeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfficeId;
    /**
     * The BookingMemberName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingMemberName;
    /**
     * The AgencyReference
     * @var string
     */
    public $AgencyReference;
    /**
     * Constructor method for AgencyDetails
     * @uses AgencyDetails::setName()
     * @uses AgencyDetails::setAddressLine1()
     * @uses AgencyDetails::setAddressLine2()
     * @uses AgencyDetails::setEmail()
     * @uses AgencyDetails::setPhone()
     * @uses AgencyDetails::setFax()
     * @uses AgencyDetails::setCity()
     * @uses AgencyDetails::setPIN()
     * @uses AgencyDetails::setOfficeId()
     * @uses AgencyDetails::setBookingMemberName()
     * @uses AgencyDetails::setAgencyReference()
     * @param string $name
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $email
     * @param string $phone
     * @param string $fax
     * @param string $city
     * @param string $pIN
     * @param string $officeId
     * @param string $bookingMemberName
     * @param string $agencyReference
     */
    public function __construct($name = null, $addressLine1 = null, $addressLine2 = null, $email = null, $phone = null, $fax = null, $city = null, $pIN = null, $officeId = null, $bookingMemberName = null, $agencyReference = null)
    {
        $this
            ->setName($name)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setEmail($email)
            ->setPhone($phone)
            ->setFax($fax)
            ->setCity($city)
            ->setPIN($pIN)
            ->setOfficeId($officeId)
            ->setBookingMemberName($bookingMemberName)
            ->setAgencyReference($agencyReference);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AgencyDetails
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AddressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \StructType\AgencyDetails
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \StructType\AgencyDetails
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\AgencyDetails
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\AgencyDetails
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\AgencyDetails
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\AgencyDetails
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \StructType\AgencyDetails
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: string
        if (!is_null($pIN) && !is_string($pIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get OfficeId value
     * @return string|null
     */
    public function getOfficeId()
    {
        return $this->OfficeId;
    }
    /**
     * Set OfficeId value
     * @param string $officeId
     * @return \StructType\AgencyDetails
     */
    public function setOfficeId($officeId = null)
    {
        // validation for constraint: string
        if (!is_null($officeId) && !is_string($officeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($officeId)), __LINE__);
        }
        $this->OfficeId = $officeId;
        return $this;
    }
    /**
     * Get BookingMemberName value
     * @return string|null
     */
    public function getBookingMemberName()
    {
        return $this->BookingMemberName;
    }
    /**
     * Set BookingMemberName value
     * @param string $bookingMemberName
     * @return \StructType\AgencyDetails
     */
    public function setBookingMemberName($bookingMemberName = null)
    {
        // validation for constraint: string
        if (!is_null($bookingMemberName) && !is_string($bookingMemberName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingMemberName)), __LINE__);
        }
        $this->BookingMemberName = $bookingMemberName;
        return $this;
    }
    /**
     * Get AgencyReference value
     * @return string|null
     */
    public function getAgencyReference()
    {
        return $this->AgencyReference;
    }
    /**
     * Set AgencyReference value
     * @param string $agencyReference
     * @return \StructType\AgencyDetails
     */
    public function setAgencyReference($agencyReference = null)
    {
        // validation for constraint: string
        if (!is_null($agencyReference) && !is_string($agencyReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencyReference)), __LINE__);
        }
        $this->AgencyReference = $agencyReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AgencyDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
