<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIHotelDetails StructType
 * @subpackage Structs
 */
class APIHotelDetails extends AbstractStructBase
{
    /**
     * The HotelRating
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $HotelRating;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The HotelLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelLocation;
    /**
     * The Attractions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString3
     */
    public $Attractions;
    /**
     * The CountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The FaxNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The HotelFacilities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString4
     */
    public $HotelFacilities;
    /**
     * The HotelPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelPolicy;
    /**
     * The Image
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Image;
    /**
     * The ImageUrls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString5
     */
    public $ImageUrls;
    /**
     * The Map
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Map;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The PinCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PinCode;
    /**
     * The RoomInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoomInfo
     */
    public $RoomInfo;
    /**
     * The RoomFacilities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString7
     */
    public $RoomFacilities;
    /**
     * The Services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Services;
    /**
     * The HotelWebsiteUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelWebsiteUrl;
    /**
     * The TripAdvisorRating
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripAdvisorRating;
    /**
     * The TripAdvisorReviewURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripAdvisorReviewURL;
    /**
     * The CityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * Constructor method for APIHotelDetails
     * @uses APIHotelDetails::setHotelRating()
     * @uses APIHotelDetails::setAddress()
     * @uses APIHotelDetails::setHotelLocation()
     * @uses APIHotelDetails::setAttractions()
     * @uses APIHotelDetails::setCountryName()
     * @uses APIHotelDetails::setDescription()
     * @uses APIHotelDetails::setEmail()
     * @uses APIHotelDetails::setFaxNumber()
     * @uses APIHotelDetails::setHotelFacilities()
     * @uses APIHotelDetails::setHotelPolicy()
     * @uses APIHotelDetails::setImage()
     * @uses APIHotelDetails::setImageUrls()
     * @uses APIHotelDetails::setMap()
     * @uses APIHotelDetails::setPhoneNumber()
     * @uses APIHotelDetails::setPinCode()
     * @uses APIHotelDetails::setRoomInfo()
     * @uses APIHotelDetails::setRoomFacilities()
     * @uses APIHotelDetails::setServices()
     * @uses APIHotelDetails::setHotelWebsiteUrl()
     * @uses APIHotelDetails::setTripAdvisorRating()
     * @uses APIHotelDetails::setTripAdvisorReviewURL()
     * @uses APIHotelDetails::setCityName()
     * @uses APIHotelDetails::setHotelCode()
     * @uses APIHotelDetails::setHotelName()
     * @param string $hotelRating
     * @param string $address
     * @param string $hotelLocation
     * @param \ArrayType\ArrayOfString3 $attractions
     * @param string $countryName
     * @param string $description
     * @param string $email
     * @param string $faxNumber
     * @param \ArrayType\ArrayOfString4 $hotelFacilities
     * @param string $hotelPolicy
     * @param string $image
     * @param \ArrayType\ArrayOfString5 $imageUrls
     * @param string $map
     * @param string $phoneNumber
     * @param string $pinCode
     * @param \ArrayType\ArrayOfRoomInfo $roomInfo
     * @param \ArrayType\ArrayOfString7 $roomFacilities
     * @param string $services
     * @param string $hotelWebsiteUrl
     * @param string $tripAdvisorRating
     * @param string $tripAdvisorReviewURL
     * @param string $cityName
     * @param string $hotelCode
     * @param string $hotelName
     */
    public function __construct($hotelRating = null, $address = null, $hotelLocation = null, \ArrayType\ArrayOfString3 $attractions = null, $countryName = null, $description = null, $email = null, $faxNumber = null, \ArrayType\ArrayOfString4 $hotelFacilities = null, $hotelPolicy = null, $image = null, \ArrayType\ArrayOfString5 $imageUrls = null, $map = null, $phoneNumber = null, $pinCode = null, \ArrayType\ArrayOfRoomInfo $roomInfo = null, \ArrayType\ArrayOfString7 $roomFacilities = null, $services = null, $hotelWebsiteUrl = null, $tripAdvisorRating = null, $tripAdvisorReviewURL = null, $cityName = null, $hotelCode = null, $hotelName = null)
    {
        $this
            ->setHotelRating($hotelRating)
            ->setAddress($address)
            ->setHotelLocation($hotelLocation)
            ->setAttractions($attractions)
            ->setCountryName($countryName)
            ->setDescription($description)
            ->setEmail($email)
            ->setFaxNumber($faxNumber)
            ->setHotelFacilities($hotelFacilities)
            ->setHotelPolicy($hotelPolicy)
            ->setImage($image)
            ->setImageUrls($imageUrls)
            ->setMap($map)
            ->setPhoneNumber($phoneNumber)
            ->setPinCode($pinCode)
            ->setRoomInfo($roomInfo)
            ->setRoomFacilities($roomFacilities)
            ->setServices($services)
            ->setHotelWebsiteUrl($hotelWebsiteUrl)
            ->setTripAdvisorRating($tripAdvisorRating)
            ->setTripAdvisorReviewURL($tripAdvisorReviewURL)
            ->setCityName($cityName)
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName);
    }
    /**
     * Get HotelRating value
     * @return string
     */
    public function getHotelRating()
    {
        return $this->HotelRating;
    }
    /**
     * Set HotelRating value
     * @uses \EnumType\HotelInfoHotelRating::valueIsValid()
     * @uses \EnumType\HotelInfoHotelRating::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hotelRating
     * @return \StructType\APIHotelDetails
     */
    public function setHotelRating($hotelRating = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelInfoHotelRating::valueIsValid($hotelRating)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hotelRating, implode(', ', \EnumType\HotelInfoHotelRating::getValidValues())), __LINE__);
        }
        $this->HotelRating = $hotelRating;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\APIHotelDetails
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get HotelLocation value
     * @return string|null
     */
    public function getHotelLocation()
    {
        return $this->HotelLocation;
    }
    /**
     * Set HotelLocation value
     * @param string $hotelLocation
     * @return \StructType\APIHotelDetails
     */
    public function setHotelLocation($hotelLocation = null)
    {
        // validation for constraint: string
        if (!is_null($hotelLocation) && !is_string($hotelLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelLocation)), __LINE__);
        }
        $this->HotelLocation = $hotelLocation;
        return $this;
    }
    /**
     * Get Attractions value
     * @return \ArrayType\ArrayOfString3|null
     */
    public function getAttractions()
    {
        return $this->Attractions;
    }
    /**
     * Set Attractions value
     * @param \ArrayType\ArrayOfString3 $attractions
     * @return \StructType\APIHotelDetails
     */
    public function setAttractions(\ArrayType\ArrayOfString3 $attractions = null)
    {
        $this->Attractions = $attractions;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \StructType\APIHotelDetails
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\APIHotelDetails
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\APIHotelDetails
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \StructType\APIHotelDetails
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get HotelFacilities value
     * @return \ArrayType\ArrayOfString4|null
     */
    public function getHotelFacilities()
    {
        return $this->HotelFacilities;
    }
    /**
     * Set HotelFacilities value
     * @param \ArrayType\ArrayOfString4 $hotelFacilities
     * @return \StructType\APIHotelDetails
     */
    public function setHotelFacilities(\ArrayType\ArrayOfString4 $hotelFacilities = null)
    {
        $this->HotelFacilities = $hotelFacilities;
        return $this;
    }
    /**
     * Get HotelPolicy value
     * @return string|null
     */
    public function getHotelPolicy()
    {
        return $this->HotelPolicy;
    }
    /**
     * Set HotelPolicy value
     * @param string $hotelPolicy
     * @return \StructType\APIHotelDetails
     */
    public function setHotelPolicy($hotelPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($hotelPolicy) && !is_string($hotelPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelPolicy)), __LINE__);
        }
        $this->HotelPolicy = $hotelPolicy;
        return $this;
    }
    /**
     * Get Image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param string $image
     * @return \StructType\APIHotelDetails
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($image)), __LINE__);
        }
        $this->Image = $image;
        return $this;
    }
    /**
     * Get ImageUrls value
     * @return \ArrayType\ArrayOfString5|null
     */
    public function getImageUrls()
    {
        return $this->ImageUrls;
    }
    /**
     * Set ImageUrls value
     * @param \ArrayType\ArrayOfString5 $imageUrls
     * @return \StructType\APIHotelDetails
     */
    public function setImageUrls(\ArrayType\ArrayOfString5 $imageUrls = null)
    {
        $this->ImageUrls = $imageUrls;
        return $this;
    }
    /**
     * Get Map value
     * @return string|null
     */
    public function getMap()
    {
        return $this->Map;
    }
    /**
     * Set Map value
     * @param string $map
     * @return \StructType\APIHotelDetails
     */
    public function setMap($map = null)
    {
        // validation for constraint: string
        if (!is_null($map) && !is_string($map)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($map)), __LINE__);
        }
        $this->Map = $map;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\APIHotelDetails
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get PinCode value
     * @return string|null
     */
    public function getPinCode()
    {
        return $this->PinCode;
    }
    /**
     * Set PinCode value
     * @param string $pinCode
     * @return \StructType\APIHotelDetails
     */
    public function setPinCode($pinCode = null)
    {
        // validation for constraint: string
        if (!is_null($pinCode) && !is_string($pinCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pinCode)), __LINE__);
        }
        $this->PinCode = $pinCode;
        return $this;
    }
    /**
     * Get RoomInfo value
     * @return \ArrayType\ArrayOfRoomInfo|null
     */
    public function getRoomInfo()
    {
        return $this->RoomInfo;
    }
    /**
     * Set RoomInfo value
     * @param \ArrayType\ArrayOfRoomInfo $roomInfo
     * @return \StructType\APIHotelDetails
     */
    public function setRoomInfo(\ArrayType\ArrayOfRoomInfo $roomInfo = null)
    {
        $this->RoomInfo = $roomInfo;
        return $this;
    }
    /**
     * Get RoomFacilities value
     * @return \ArrayType\ArrayOfString7|null
     */
    public function getRoomFacilities()
    {
        return $this->RoomFacilities;
    }
    /**
     * Set RoomFacilities value
     * @param \ArrayType\ArrayOfString7 $roomFacilities
     * @return \StructType\APIHotelDetails
     */
    public function setRoomFacilities(\ArrayType\ArrayOfString7 $roomFacilities = null)
    {
        $this->RoomFacilities = $roomFacilities;
        return $this;
    }
    /**
     * Get Services value
     * @return string|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param string $services
     * @return \StructType\APIHotelDetails
     */
    public function setServices($services = null)
    {
        // validation for constraint: string
        if (!is_null($services) && !is_string($services)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($services)), __LINE__);
        }
        $this->Services = $services;
        return $this;
    }
    /**
     * Get HotelWebsiteUrl value
     * @return string|null
     */
    public function getHotelWebsiteUrl()
    {
        return $this->HotelWebsiteUrl;
    }
    /**
     * Set HotelWebsiteUrl value
     * @param string $hotelWebsiteUrl
     * @return \StructType\APIHotelDetails
     */
    public function setHotelWebsiteUrl($hotelWebsiteUrl = null)
    {
        // validation for constraint: string
        if (!is_null($hotelWebsiteUrl) && !is_string($hotelWebsiteUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelWebsiteUrl)), __LINE__);
        }
        $this->HotelWebsiteUrl = $hotelWebsiteUrl;
        return $this;
    }
    /**
     * Get TripAdvisorRating value
     * @return string|null
     */
    public function getTripAdvisorRating()
    {
        return $this->TripAdvisorRating;
    }
    /**
     * Set TripAdvisorRating value
     * @param string $tripAdvisorRating
     * @return \StructType\APIHotelDetails
     */
    public function setTripAdvisorRating($tripAdvisorRating = null)
    {
        // validation for constraint: string
        if (!is_null($tripAdvisorRating) && !is_string($tripAdvisorRating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tripAdvisorRating)), __LINE__);
        }
        $this->TripAdvisorRating = $tripAdvisorRating;
        return $this;
    }
    /**
     * Get TripAdvisorReviewURL value
     * @return string|null
     */
    public function getTripAdvisorReviewURL()
    {
        return $this->TripAdvisorReviewURL;
    }
    /**
     * Set TripAdvisorReviewURL value
     * @param string $tripAdvisorReviewURL
     * @return \StructType\APIHotelDetails
     */
    public function setTripAdvisorReviewURL($tripAdvisorReviewURL = null)
    {
        // validation for constraint: string
        if (!is_null($tripAdvisorReviewURL) && !is_string($tripAdvisorReviewURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tripAdvisorReviewURL)), __LINE__);
        }
        $this->TripAdvisorReviewURL = $tripAdvisorReviewURL;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\APIHotelDetails
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\APIHotelDetails
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\APIHotelDetails
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\APIHotelDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
