<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIBookingDetail StructType
 * @subpackage Structs
 */
class APIBookingDetail extends AbstractStructBase
{
    /**
     * The Rating
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Rating;
    /**
     * The CheckInDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CheckInDate;
    /**
     * The CheckOutDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CheckOutDate;
    /**
     * The BookingDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BookingDate;
    /**
     * The NoOfRooms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NoOfRooms;
    /**
     * The CityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CityId;
    /**
     * The BookingId
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $BookingId;
    /**
     * The AmendmentStatus
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $AmendmentStatus;
    /**
     * The BookingStatus
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $BookingStatus;
    /**
     * The VoucherStatus
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $VoucherStatus;
    /**
     * The HotelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelName;
    /**
     * The AddressLine1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine2;
    /**
     * The Map
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Map;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The HotelCancelPolicies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CancelPolicies
     */
    public $HotelCancelPolicies;
    /**
     * The HotelPolicyDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelPolicyDetails;
    /**
     * The FlightInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlightInfo;
    /**
     * The SpecialRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SpecialRequest;
    /**
     * The Roomtype
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoomDetails
     */
    public $Roomtype;
    /**
     * The AmendmentDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmendmentDetails
     */
    public $AmendmentDetails;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The AgencyDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AgencyDetails
     */
    public $AgencyDetails;
    /**
     * The AOTNumbers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AOTNumbers
     */
    public $AOTNumbers;
    /**
     * The InvoiceNumber
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The SupplierReferenceNo
     * @var string
     */
    public $SupplierReferenceNo;
    /**
     * The ConfirmationNo
     * @var string
     */
    public $ConfirmationNo;
    /**
     * The HotelConfirmationNo
     * @var string
     */
    public $HotelConfirmationNo;
    /**
     * Constructor method for APIBookingDetail
     * @uses APIBookingDetail::setRating()
     * @uses APIBookingDetail::setCheckInDate()
     * @uses APIBookingDetail::setCheckOutDate()
     * @uses APIBookingDetail::setBookingDate()
     * @uses APIBookingDetail::setNoOfRooms()
     * @uses APIBookingDetail::setCityId()
     * @uses APIBookingDetail::setBookingId()
     * @uses APIBookingDetail::setAmendmentStatus()
     * @uses APIBookingDetail::setBookingStatus()
     * @uses APIBookingDetail::setVoucherStatus()
     * @uses APIBookingDetail::setHotelName()
     * @uses APIBookingDetail::setAddressLine1()
     * @uses APIBookingDetail::setAddressLine2()
     * @uses APIBookingDetail::setMap()
     * @uses APIBookingDetail::setCity()
     * @uses APIBookingDetail::setHotelCancelPolicies()
     * @uses APIBookingDetail::setHotelPolicyDetails()
     * @uses APIBookingDetail::setFlightInfo()
     * @uses APIBookingDetail::setSpecialRequest()
     * @uses APIBookingDetail::setRoomtype()
     * @uses APIBookingDetail::setAmendmentDetails()
     * @uses APIBookingDetail::setCurrency()
     * @uses APIBookingDetail::setAgencyDetails()
     * @uses APIBookingDetail::setAOTNumbers()
     * @uses APIBookingDetail::setInvoiceNumber()
     * @uses APIBookingDetail::setSupplierReferenceNo()
     * @uses APIBookingDetail::setConfirmationNo()
     * @uses APIBookingDetail::setHotelConfirmationNo()
     * @param string $rating
     * @param string $checkInDate
     * @param string $checkOutDate
     * @param string $bookingDate
     * @param int $noOfRooms
     * @param int $cityId
     * @param int $bookingId
     * @param string $amendmentStatus
     * @param string $bookingStatus
     * @param bool $voucherStatus
     * @param string $hotelName
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $map
     * @param string $city
     * @param \StructType\CancelPolicies $hotelCancelPolicies
     * @param string $hotelPolicyDetails
     * @param string $flightInfo
     * @param string $specialRequest
     * @param \ArrayType\ArrayOfRoomDetails $roomtype
     * @param \StructType\AmendmentDetails $amendmentDetails
     * @param string $currency
     * @param \StructType\AgencyDetails $agencyDetails
     * @param \StructType\AOTNumbers $aOTNumbers
     * @param string $invoiceNumber
     * @param string $supplierReferenceNo
     * @param string $confirmationNo
     * @param string $hotelConfirmationNo
     */
    public function __construct($rating = null, $checkInDate = null, $checkOutDate = null, $bookingDate = null, $noOfRooms = null, $cityId = null, $bookingId = null, $amendmentStatus = null, $bookingStatus = null, $voucherStatus = null, $hotelName = null, $addressLine1 = null, $addressLine2 = null, $map = null, $city = null, \StructType\CancelPolicies $hotelCancelPolicies = null, $hotelPolicyDetails = null, $flightInfo = null, $specialRequest = null, \ArrayType\ArrayOfRoomDetails $roomtype = null, \StructType\AmendmentDetails $amendmentDetails = null, $currency = null, \StructType\AgencyDetails $agencyDetails = null, \StructType\AOTNumbers $aOTNumbers = null, $invoiceNumber = null, $supplierReferenceNo = null, $confirmationNo = null, $hotelConfirmationNo = null)
    {
        $this
            ->setRating($rating)
            ->setCheckInDate($checkInDate)
            ->setCheckOutDate($checkOutDate)
            ->setBookingDate($bookingDate)
            ->setNoOfRooms($noOfRooms)
            ->setCityId($cityId)
            ->setBookingId($bookingId)
            ->setAmendmentStatus($amendmentStatus)
            ->setBookingStatus($bookingStatus)
            ->setVoucherStatus($voucherStatus)
            ->setHotelName($hotelName)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setMap($map)
            ->setCity($city)
            ->setHotelCancelPolicies($hotelCancelPolicies)
            ->setHotelPolicyDetails($hotelPolicyDetails)
            ->setFlightInfo($flightInfo)
            ->setSpecialRequest($specialRequest)
            ->setRoomtype($roomtype)
            ->setAmendmentDetails($amendmentDetails)
            ->setCurrency($currency)
            ->setAgencyDetails($agencyDetails)
            ->setAOTNumbers($aOTNumbers)
            ->setInvoiceNumber($invoiceNumber)
            ->setSupplierReferenceNo($supplierReferenceNo)
            ->setConfirmationNo($confirmationNo)
            ->setHotelConfirmationNo($hotelConfirmationNo);
    }
    /**
     * Get Rating value
     * @return string
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @uses \EnumType\HotelInfoHotelRating::valueIsValid()
     * @uses \EnumType\HotelInfoHotelRating::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rating
     * @return \StructType\APIBookingDetail
     */
    public function setRating($rating = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelInfoHotelRating::valueIsValid($rating)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rating, implode(', ', \EnumType\HotelInfoHotelRating::getValidValues())), __LINE__);
        }
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Get CheckInDate value
     * @return string
     */
    public function getCheckInDate()
    {
        return $this->CheckInDate;
    }
    /**
     * Set CheckInDate value
     * @param string $checkInDate
     * @return \StructType\APIBookingDetail
     */
    public function setCheckInDate($checkInDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDate) && !is_string($checkInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkInDate)), __LINE__);
        }
        $this->CheckInDate = $checkInDate;
        return $this;
    }
    /**
     * Get CheckOutDate value
     * @return string
     */
    public function getCheckOutDate()
    {
        return $this->CheckOutDate;
    }
    /**
     * Set CheckOutDate value
     * @param string $checkOutDate
     * @return \StructType\APIBookingDetail
     */
    public function setCheckOutDate($checkOutDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkOutDate) && !is_string($checkOutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkOutDate)), __LINE__);
        }
        $this->CheckOutDate = $checkOutDate;
        return $this;
    }
    /**
     * Get BookingDate value
     * @return string
     */
    public function getBookingDate()
    {
        return $this->BookingDate;
    }
    /**
     * Set BookingDate value
     * @param string $bookingDate
     * @return \StructType\APIBookingDetail
     */
    public function setBookingDate($bookingDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDate) && !is_string($bookingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingDate)), __LINE__);
        }
        $this->BookingDate = $bookingDate;
        return $this;
    }
    /**
     * Get NoOfRooms value
     * @return int
     */
    public function getNoOfRooms()
    {
        return $this->NoOfRooms;
    }
    /**
     * Set NoOfRooms value
     * @param int $noOfRooms
     * @return \StructType\APIBookingDetail
     */
    public function setNoOfRooms($noOfRooms = null)
    {
        // validation for constraint: int
        if (!is_null($noOfRooms) && !is_numeric($noOfRooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noOfRooms)), __LINE__);
        }
        $this->NoOfRooms = $noOfRooms;
        return $this;
    }
    /**
     * Get CityId value
     * @return int
     */
    public function getCityId()
    {
        return $this->CityId;
    }
    /**
     * Set CityId value
     * @param int $cityId
     * @return \StructType\APIBookingDetail
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: int
        if (!is_null($cityId) && !is_numeric($cityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cityId)), __LINE__);
        }
        $this->CityId = $cityId;
        return $this;
    }
    /**
     * Get BookingId value
     * @return int
     */
    public function getBookingId()
    {
        return $this->BookingId;
    }
    /**
     * Set BookingId value
     * @param int $bookingId
     * @return \StructType\APIBookingDetail
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: int
        if (!is_null($bookingId) && !is_numeric($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bookingId)), __LINE__);
        }
        $this->BookingId = $bookingId;
        return $this;
    }
    /**
     * Get AmendmentStatus value
     * @return string
     */
    public function getAmendmentStatus()
    {
        return $this->AmendmentStatus;
    }
    /**
     * Set AmendmentStatus value
     * @uses \EnumType\RequestStatus::valueIsValid()
     * @uses \EnumType\RequestStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amendmentStatus
     * @return \StructType\APIBookingDetail
     */
    public function setAmendmentStatus($amendmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RequestStatus::valueIsValid($amendmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $amendmentStatus, implode(', ', \EnumType\RequestStatus::getValidValues())), __LINE__);
        }
        $this->AmendmentStatus = $amendmentStatus;
        return $this;
    }
    /**
     * Get BookingStatus value
     * @return string
     */
    public function getBookingStatus()
    {
        return $this->BookingStatus;
    }
    /**
     * Set BookingStatus value
     * @uses \EnumType\APIHotelBookingStatus::valueIsValid()
     * @uses \EnumType\APIHotelBookingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingStatus
     * @return \StructType\APIBookingDetail
     */
    public function setBookingStatus($bookingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\APIHotelBookingStatus::valueIsValid($bookingStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bookingStatus, implode(', ', \EnumType\APIHotelBookingStatus::getValidValues())), __LINE__);
        }
        $this->BookingStatus = $bookingStatus;
        return $this;
    }
    /**
     * Get VoucherStatus value
     * @return bool
     */
    public function getVoucherStatus()
    {
        return $this->VoucherStatus;
    }
    /**
     * Set VoucherStatus value
     * @param bool $voucherStatus
     * @return \StructType\APIBookingDetail
     */
    public function setVoucherStatus($voucherStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($voucherStatus) && !is_bool($voucherStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($voucherStatus)), __LINE__);
        }
        $this->VoucherStatus = $voucherStatus;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\APIBookingDetail
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get AddressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \StructType\APIBookingDetail
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \StructType\APIBookingDetail
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get Map value
     * @return string|null
     */
    public function getMap()
    {
        return $this->Map;
    }
    /**
     * Set Map value
     * @param string $map
     * @return \StructType\APIBookingDetail
     */
    public function setMap($map = null)
    {
        // validation for constraint: string
        if (!is_null($map) && !is_string($map)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($map)), __LINE__);
        }
        $this->Map = $map;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\APIBookingDetail
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get HotelCancelPolicies value
     * @return \StructType\CancelPolicies|null
     */
    public function getHotelCancelPolicies()
    {
        return $this->HotelCancelPolicies;
    }
    /**
     * Set HotelCancelPolicies value
     * @param \StructType\CancelPolicies $hotelCancelPolicies
     * @return \StructType\APIBookingDetail
     */
    public function setHotelCancelPolicies(\StructType\CancelPolicies $hotelCancelPolicies = null)
    {
        $this->HotelCancelPolicies = $hotelCancelPolicies;
        return $this;
    }
    /**
     * Get HotelPolicyDetails value
     * @return string|null
     */
    public function getHotelPolicyDetails()
    {
        return $this->HotelPolicyDetails;
    }
    /**
     * Set HotelPolicyDetails value
     * @param string $hotelPolicyDetails
     * @return \StructType\APIBookingDetail
     */
    public function setHotelPolicyDetails($hotelPolicyDetails = null)
    {
        // validation for constraint: string
        if (!is_null($hotelPolicyDetails) && !is_string($hotelPolicyDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelPolicyDetails)), __LINE__);
        }
        $this->HotelPolicyDetails = $hotelPolicyDetails;
        return $this;
    }
    /**
     * Get FlightInfo value
     * @return string|null
     */
    public function getFlightInfo()
    {
        return $this->FlightInfo;
    }
    /**
     * Set FlightInfo value
     * @param string $flightInfo
     * @return \StructType\APIBookingDetail
     */
    public function setFlightInfo($flightInfo = null)
    {
        // validation for constraint: string
        if (!is_null($flightInfo) && !is_string($flightInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightInfo)), __LINE__);
        }
        $this->FlightInfo = $flightInfo;
        return $this;
    }
    /**
     * Get SpecialRequest value
     * @return string|null
     */
    public function getSpecialRequest()
    {
        return $this->SpecialRequest;
    }
    /**
     * Set SpecialRequest value
     * @param string $specialRequest
     * @return \StructType\APIBookingDetail
     */
    public function setSpecialRequest($specialRequest = null)
    {
        // validation for constraint: string
        if (!is_null($specialRequest) && !is_string($specialRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($specialRequest)), __LINE__);
        }
        $this->SpecialRequest = $specialRequest;
        return $this;
    }
    /**
     * Get Roomtype value
     * @return \ArrayType\ArrayOfRoomDetails|null
     */
    public function getRoomtype()
    {
        return $this->Roomtype;
    }
    /**
     * Set Roomtype value
     * @param \ArrayType\ArrayOfRoomDetails $roomtype
     * @return \StructType\APIBookingDetail
     */
    public function setRoomtype(\ArrayType\ArrayOfRoomDetails $roomtype = null)
    {
        $this->Roomtype = $roomtype;
        return $this;
    }
    /**
     * Get AmendmentDetails value
     * @return \StructType\AmendmentDetails|null
     */
    public function getAmendmentDetails()
    {
        return $this->AmendmentDetails;
    }
    /**
     * Set AmendmentDetails value
     * @param \StructType\AmendmentDetails $amendmentDetails
     * @return \StructType\APIBookingDetail
     */
    public function setAmendmentDetails(\StructType\AmendmentDetails $amendmentDetails = null)
    {
        $this->AmendmentDetails = $amendmentDetails;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\APIBookingDetail
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get AgencyDetails value
     * @return \StructType\AgencyDetails|null
     */
    public function getAgencyDetails()
    {
        return $this->AgencyDetails;
    }
    /**
     * Set AgencyDetails value
     * @param \StructType\AgencyDetails $agencyDetails
     * @return \StructType\APIBookingDetail
     */
    public function setAgencyDetails(\StructType\AgencyDetails $agencyDetails = null)
    {
        $this->AgencyDetails = $agencyDetails;
        return $this;
    }
    /**
     * Get AOTNumbers value
     * @return \StructType\AOTNumbers|null
     */
    public function getAOTNumbers()
    {
        return $this->AOTNumbers;
    }
    /**
     * Set AOTNumbers value
     * @param \StructType\AOTNumbers $aOTNumbers
     * @return \StructType\APIBookingDetail
     */
    public function setAOTNumbers(\StructType\AOTNumbers $aOTNumbers = null)
    {
        $this->AOTNumbers = $aOTNumbers;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\APIBookingDetail
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get SupplierReferenceNo value
     * @return string|null
     */
    public function getSupplierReferenceNo()
    {
        return $this->SupplierReferenceNo;
    }
    /**
     * Set SupplierReferenceNo value
     * @param string $supplierReferenceNo
     * @return \StructType\APIBookingDetail
     */
    public function setSupplierReferenceNo($supplierReferenceNo = null)
    {
        // validation for constraint: string
        if (!is_null($supplierReferenceNo) && !is_string($supplierReferenceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierReferenceNo)), __LINE__);
        }
        $this->SupplierReferenceNo = $supplierReferenceNo;
        return $this;
    }
    /**
     * Get ConfirmationNo value
     * @return string|null
     */
    public function getConfirmationNo()
    {
        return $this->ConfirmationNo;
    }
    /**
     * Set ConfirmationNo value
     * @param string $confirmationNo
     * @return \StructType\APIBookingDetail
     */
    public function setConfirmationNo($confirmationNo = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNo) && !is_string($confirmationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confirmationNo)), __LINE__);
        }
        $this->ConfirmationNo = $confirmationNo;
        return $this;
    }
    /**
     * Get HotelConfirmationNo value
     * @return string|null
     */
    public function getHotelConfirmationNo()
    {
        return $this->HotelConfirmationNo;
    }
    /**
     * Set HotelConfirmationNo value
     * @param string $hotelConfirmationNo
     * @return \StructType\APIBookingDetail
     */
    public function setHotelConfirmationNo($hotelConfirmationNo = null)
    {
        // validation for constraint: string
        if (!is_null($hotelConfirmationNo) && !is_string($hotelConfirmationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelConfirmationNo)), __LINE__);
        }
        $this->HotelConfirmationNo = $hotelConfirmationNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\APIBookingDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
