<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AOTNumbers StructType
 * @subpackage Structs
 */
class AOTNumbers extends AbstractStructBase
{
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contact;
    /**
     * The IntlCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntlCall;
    /**
     * The DomesticCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomesticCall;
    /**
     * The LocalCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalCall;
    /**
     * The OfficeHours
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfficeHours;
    /**
     * The Emergency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Emergency;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * Constructor method for AOTNumbers
     * @uses AOTNumbers::setCountry()
     * @uses AOTNumbers::setContact()
     * @uses AOTNumbers::setIntlCall()
     * @uses AOTNumbers::setDomesticCall()
     * @uses AOTNumbers::setLocalCall()
     * @uses AOTNumbers::setOfficeHours()
     * @uses AOTNumbers::setEmergency()
     * @uses AOTNumbers::setLanguage()
     * @param string $country
     * @param string $contact
     * @param string $intlCall
     * @param string $domesticCall
     * @param string $localCall
     * @param string $officeHours
     * @param string $emergency
     * @param string $language
     */
    public function __construct($country = null, $contact = null, $intlCall = null, $domesticCall = null, $localCall = null, $officeHours = null, $emergency = null, $language = null)
    {
        $this
            ->setCountry($country)
            ->setContact($contact)
            ->setIntlCall($intlCall)
            ->setDomesticCall($domesticCall)
            ->setLocalCall($localCall)
            ->setOfficeHours($officeHours)
            ->setEmergency($emergency)
            ->setLanguage($language);
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\AOTNumbers
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param string $contact
     * @return \StructType\AOTNumbers
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contact)), __LINE__);
        }
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get IntlCall value
     * @return string|null
     */
    public function getIntlCall()
    {
        return $this->IntlCall;
    }
    /**
     * Set IntlCall value
     * @param string $intlCall
     * @return \StructType\AOTNumbers
     */
    public function setIntlCall($intlCall = null)
    {
        // validation for constraint: string
        if (!is_null($intlCall) && !is_string($intlCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intlCall)), __LINE__);
        }
        $this->IntlCall = $intlCall;
        return $this;
    }
    /**
     * Get DomesticCall value
     * @return string|null
     */
    public function getDomesticCall()
    {
        return $this->DomesticCall;
    }
    /**
     * Set DomesticCall value
     * @param string $domesticCall
     * @return \StructType\AOTNumbers
     */
    public function setDomesticCall($domesticCall = null)
    {
        // validation for constraint: string
        if (!is_null($domesticCall) && !is_string($domesticCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domesticCall)), __LINE__);
        }
        $this->DomesticCall = $domesticCall;
        return $this;
    }
    /**
     * Get LocalCall value
     * @return string|null
     */
    public function getLocalCall()
    {
        return $this->LocalCall;
    }
    /**
     * Set LocalCall value
     * @param string $localCall
     * @return \StructType\AOTNumbers
     */
    public function setLocalCall($localCall = null)
    {
        // validation for constraint: string
        if (!is_null($localCall) && !is_string($localCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localCall)), __LINE__);
        }
        $this->LocalCall = $localCall;
        return $this;
    }
    /**
     * Get OfficeHours value
     * @return string|null
     */
    public function getOfficeHours()
    {
        return $this->OfficeHours;
    }
    /**
     * Set OfficeHours value
     * @param string $officeHours
     * @return \StructType\AOTNumbers
     */
    public function setOfficeHours($officeHours = null)
    {
        // validation for constraint: string
        if (!is_null($officeHours) && !is_string($officeHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($officeHours)), __LINE__);
        }
        $this->OfficeHours = $officeHours;
        return $this;
    }
    /**
     * Get Emergency value
     * @return string|null
     */
    public function getEmergency()
    {
        return $this->Emergency;
    }
    /**
     * Set Emergency value
     * @param string $emergency
     * @return \StructType\AOTNumbers
     */
    public function setEmergency($emergency = null)
    {
        // validation for constraint: string
        if (!is_null($emergency) && !is_string($emergency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emergency)), __LINE__);
        }
        $this->Emergency = $emergency;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\AOTNumbers
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AOTNumbers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
