<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hotel ServiceType
 * @subpackage Services
 */
class Hotel extends AbstractSoapClientBase
{
    /**
     * Sets the Credentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthenticationData $credentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCredentials(\StructType\AuthenticationData $credentials, $nameSpace = 'http://TekTravel/HotelBookingApi', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Credentials', $credentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named HotelSearch
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Credentials
     * - SOAPHeaderNamespaces: http://TekTravel/HotelBookingApi
     * - SOAPHeaderTypes: \StructType\AuthenticationData
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelSearchRequest $parameters
     * @return \StructType\HotelSearchResponse|bool
     */
    public function HotelSearch(\StructType\HotelSearchRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->HotelSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelCancellationPolicy
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Credentials
     * - SOAPHeaderNamespaces: http://TekTravel/HotelBookingApi
     * - SOAPHeaderTypes: \StructType\AuthenticationData
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelCancellationPolicyRequest $parameters
     * @return \StructType\HotelCancellationPolicyResponse|bool
     */
    public function HotelCancellationPolicy(\StructType\HotelCancellationPolicyRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->HotelCancellationPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelCancellationPolicyForAllRooms
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Credentials
     * - SOAPHeaderNamespaces: http://TekTravel/HotelBookingApi
     * - SOAPHeaderTypes: \StructType\AuthenticationData
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelCancellationPolicyRequest $parameters
     * @return \StructType\HotelCancellationPolicyResponse|bool
     */
    public function HotelCancellationPolicyForAllRooms(\StructType\HotelCancellationPolicyRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->HotelCancellationPolicyForAllRooms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelBook
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Credentials
     * - SOAPHeaderNamespaces: http://TekTravel/HotelBookingApi
     * - SOAPHeaderTypes: \StructType\AuthenticationData
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelBookRequest $parameters
     * @return \StructType\HotelBookResponse|bool
     */
    public function HotelBook(\StructType\HotelBookRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->HotelBook($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelBookingDetail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Credentials
     * - SOAPHeaderNamespaces: http://TekTravel/HotelBookingApi
     * - SOAPHeaderTypes: \StructType\AuthenticationData
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelBookingDetailRequest $parameters
     * @return \StructType\HotelBookingDetailResponse|bool
     */
    public function HotelBookingDetail(\StructType\HotelBookingDetailRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->HotelBookingDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelCancel
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Credentials
     * - SOAPHeaderNamespaces: http://TekTravel/HotelBookingApi
     * - SOAPHeaderTypes: \StructType\AuthenticationData
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelCancelRequest $parameters
     * @return \StructType\HotelCancelResponse|bool
     */
    public function HotelCancel(\StructType\HotelCancelRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->HotelCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelDetails
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Credentials
     * - SOAPHeaderNamespaces: http://TekTravel/HotelBookingApi
     * - SOAPHeaderTypes: \StructType\AuthenticationData
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelDetailsRequest $parameters
     * @return \StructType\HotelDetailsResponse|bool
     */
    public function HotelDetails(\StructType\HotelDetailsRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->HotelDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelCodeList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Credentials
     * - SOAPHeaderNamespaces: http://TekTravel/HotelBookingApi
     * - SOAPHeaderTypes: \StructType\AuthenticationData
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelCodesRequest $parameters
     * @return \StructType\HotelCodesResponse|bool
     */
    public function HotelCodeList(\StructType\HotelCodesRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->HotelCodeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelSearchWithRooms
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Credentials
     * - SOAPHeaderNamespaces: http://TekTravel/HotelBookingApi
     * - SOAPHeaderTypes: \StructType\AuthenticationData
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelSearchWithRoomsRequest $parameters
     * @return \StructType\HotelSearchWithRoomsResponse|bool
     */
    public function HotelSearchWithRooms(\StructType\HotelSearchWithRoomsRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->HotelSearchWithRooms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelBookingDetailBasedOnDate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Credentials
     * - SOAPHeaderNamespaces: http://TekTravel/HotelBookingApi
     * - SOAPHeaderTypes: \StructType\AuthenticationData
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HotelBookingDetailBasedOnDateRequest $parameters
     * @return \StructType\HotelBookingDetailBasedOnDateResponse|bool
     */
    public function HotelBookingDetailBasedOnDate(\StructType\HotelBookingDetailBasedOnDateRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->HotelBookingDetailBasedOnDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HotelBookingDetailBasedOnDateResponse|\StructType\HotelBookingDetailResponse|\StructType\HotelBookResponse|\StructType\HotelCancellationPolicyResponse|\StructType\HotelCancelResponse|\StructType\HotelCodesResponse|\StructType\HotelDetailsResponse|\StructType\HotelSearchResponse|\StructType\HotelSearchWithRoomsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
