<?php

namespace EnumType;

/**
 * This class stands for SupplementType EnumType
 * @subpackage Enumerations
 */
class SupplementType
{
    /**
     * Constant for value 'PerStaySupplement'
     * @return string 'PerStaySupplement'
     */
    const VALUE_PER_STAY_SUPPLEMENT = 'PerStaySupplement';
    /**
     * Constant for value 'PerPersonSupplement'
     * @return string 'PerPersonSupplement'
     */
    const VALUE_PER_PERSON_SUPPLEMENT = 'PerPersonSupplement';
    /**
     * Constant for value 'PerRoomSupplement'
     * @return string 'PerRoomSupplement'
     */
    const VALUE_PER_ROOM_SUPPLEMENT = 'PerRoomSupplement';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PER_STAY_SUPPLEMENT
     * @uses self::VALUE_PER_PERSON_SUPPLEMENT
     * @uses self::VALUE_PER_ROOM_SUPPLEMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PER_STAY_SUPPLEMENT,
            self::VALUE_PER_PERSON_SUPPLEMENT,
            self::VALUE_PER_ROOM_SUPPLEMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
