<?php

namespace EnumType;

/**
 * This class stands for SupmtChargeType EnumType
 * @subpackage Enumerations
 */
class SupmtChargeType
{
    /**
     * Constant for value 'Included'
     * @return string 'Included'
     */
    const VALUE_INCLUDED = 'Included';
    /**
     * Constant for value 'Addition'
     * @return string 'Addition'
     */
    const VALUE_ADDITION = 'Addition';
    /**
     * Constant for value 'AtProperty'
     * @return string 'AtProperty'
     */
    const VALUE_AT_PROPERTY = 'AtProperty';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INCLUDED
     * @uses self::VALUE_ADDITION
     * @uses self::VALUE_AT_PROPERTY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INCLUDED,
            self::VALUE_ADDITION,
            self::VALUE_AT_PROPERTY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
