<?php

namespace EnumType;

/**
 * This class stands for RoomRequested EnumType
 * @subpackage Enumerations
 */
class RoomRequested
{
    /**
     * Constant for value 'FirstRoom'
     * @return string 'FirstRoom'
     */
    const VALUE_FIRST_ROOM = 'FirstRoom';
    /**
     * Constant for value 'SecondRoom'
     * @return string 'SecondRoom'
     */
    const VALUE_SECOND_ROOM = 'SecondRoom';
    /**
     * Constant for value 'ThirdRoom'
     * @return string 'ThirdRoom'
     */
    const VALUE_THIRD_ROOM = 'ThirdRoom';
    /**
     * Constant for value 'FourthRoom'
     * @return string 'FourthRoom'
     */
    const VALUE_FOURTH_ROOM = 'FourthRoom';
    /**
     * Constant for value 'FifthRoom'
     * @return string 'FifthRoom'
     */
    const VALUE_FIFTH_ROOM = 'FifthRoom';
    /**
     * Constant for value 'SixthRoom'
     * @return string 'SixthRoom'
     */
    const VALUE_SIXTH_ROOM = 'SixthRoom';
    /**
     * Constant for value 'SeventhRoom'
     * @return string 'SeventhRoom'
     */
    const VALUE_SEVENTH_ROOM = 'SeventhRoom';
    /**
     * Constant for value 'EighthRoom'
     * @return string 'EighthRoom'
     */
    const VALUE_EIGHTH_ROOM = 'EighthRoom';
    /**
     * Constant for value 'NinthRoom'
     * @return string 'NinthRoom'
     */
    const VALUE_NINTH_ROOM = 'NinthRoom';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIRST_ROOM
     * @uses self::VALUE_SECOND_ROOM
     * @uses self::VALUE_THIRD_ROOM
     * @uses self::VALUE_FOURTH_ROOM
     * @uses self::VALUE_FIFTH_ROOM
     * @uses self::VALUE_SIXTH_ROOM
     * @uses self::VALUE_SEVENTH_ROOM
     * @uses self::VALUE_EIGHTH_ROOM
     * @uses self::VALUE_NINTH_ROOM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIRST_ROOM,
            self::VALUE_SECOND_ROOM,
            self::VALUE_THIRD_ROOM,
            self::VALUE_FOURTH_ROOM,
            self::VALUE_FIFTH_ROOM,
            self::VALUE_SIXTH_ROOM,
            self::VALUE_SEVENTH_ROOM,
            self::VALUE_EIGHTH_ROOM,
            self::VALUE_NINTH_ROOM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
