<?php

namespace EnumType;

/**
 * This class stands for PolicyFormat EnumType
 * @subpackage Enumerations
 */
class PolicyFormat
{
    /**
     * Constant for value 'Text'
     * @return string 'Text'
     */
    const VALUE_TEXT = 'Text';
    /**
     * Constant for value 'Nodes'
     * @return string 'Nodes'
     */
    const VALUE_NODES = 'Nodes';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TEXT
     * @uses self::VALUE_NODES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TEXT,
            self::VALUE_NODES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
