<?php

namespace EnumType;

/**
 * This class stands for PaymentModeType EnumType
 * @subpackage Enumerations
 */
class PaymentModeType
{
    /**
     * Constant for value 'Limit'
     * @return string 'Limit'
     */
    const VALUE_LIMIT = 'Limit';
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'Fawry'
     * @return string 'Fawry'
     */
    const VALUE_FAWRY = 'Fawry';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LIMIT
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_FAWRY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LIMIT,
            self::VALUE_CREDIT_CARD,
            self::VALUE_FAWRY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
