<?php

namespace EnumType;

/**
 * This class stands for OrderByFilter EnumType
 * @subpackage Enumerations
 */
class OrderByFilter
{
    /**
     * Constant for value 'PriceAsc'
     * @return string 'PriceAsc'
     */
    const VALUE_PRICE_ASC = 'PriceAsc';
    /**
     * Constant for value 'PriceDesc'
     * @return string 'PriceDesc'
     */
    const VALUE_PRICE_DESC = 'PriceDesc';
    /**
     * Constant for value 'StarRatingAsc'
     * @return string 'StarRatingAsc'
     */
    const VALUE_STAR_RATING_ASC = 'StarRatingAsc';
    /**
     * Constant for value 'StarRatingDesc'
     * @return string 'StarRatingDesc'
     */
    const VALUE_STAR_RATING_DESC = 'StarRatingDesc';
    /**
     * Constant for value 'TBOPreference'
     * @return string 'TBOPreference'
     */
    const VALUE_TBOPREFERENCE = 'TBOPreference';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRICE_ASC
     * @uses self::VALUE_PRICE_DESC
     * @uses self::VALUE_STAR_RATING_ASC
     * @uses self::VALUE_STAR_RATING_DESC
     * @uses self::VALUE_TBOPREFERENCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRICE_ASC,
            self::VALUE_PRICE_DESC,
            self::VALUE_STAR_RATING_ASC,
            self::VALUE_STAR_RATING_DESC,
            self::VALUE_TBOPREFERENCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
