<?php

namespace EnumType;

/**
 * This class stands for HotelRatingInput EnumType
 * @subpackage Enumerations
 */
class HotelRatingInput
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'OneStarOrLess'
     * @return string 'OneStarOrLess'
     */
    const VALUE_ONE_STAR_OR_LESS = 'OneStarOrLess';
    /**
     * Constant for value 'TwoStarOrLess'
     * @return string 'TwoStarOrLess'
     */
    const VALUE_TWO_STAR_OR_LESS = 'TwoStarOrLess';
    /**
     * Constant for value 'ThreeStarOrLess'
     * @return string 'ThreeStarOrLess'
     */
    const VALUE_THREE_STAR_OR_LESS = 'ThreeStarOrLess';
    /**
     * Constant for value 'FourStarOrLess'
     * @return string 'FourStarOrLess'
     */
    const VALUE_FOUR_STAR_OR_LESS = 'FourStarOrLess';
    /**
     * Constant for value 'FiveStarOrLess'
     * @return string 'FiveStarOrLess'
     */
    const VALUE_FIVE_STAR_OR_LESS = 'FiveStarOrLess';
    /**
     * Constant for value 'OneStarOrMore'
     * @return string 'OneStarOrMore'
     */
    const VALUE_ONE_STAR_OR_MORE = 'OneStarOrMore';
    /**
     * Constant for value 'TwoStarOrMore'
     * @return string 'TwoStarOrMore'
     */
    const VALUE_TWO_STAR_OR_MORE = 'TwoStarOrMore';
    /**
     * Constant for value 'ThreeStarOrMore'
     * @return string 'ThreeStarOrMore'
     */
    const VALUE_THREE_STAR_OR_MORE = 'ThreeStarOrMore';
    /**
     * Constant for value 'FourStarOrMore'
     * @return string 'FourStarOrMore'
     */
    const VALUE_FOUR_STAR_OR_MORE = 'FourStarOrMore';
    /**
     * Constant for value 'FiveStarOrMore'
     * @return string 'FiveStarOrMore'
     */
    const VALUE_FIVE_STAR_OR_MORE = 'FiveStarOrMore';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_ONE_STAR_OR_LESS
     * @uses self::VALUE_TWO_STAR_OR_LESS
     * @uses self::VALUE_THREE_STAR_OR_LESS
     * @uses self::VALUE_FOUR_STAR_OR_LESS
     * @uses self::VALUE_FIVE_STAR_OR_LESS
     * @uses self::VALUE_ONE_STAR_OR_MORE
     * @uses self::VALUE_TWO_STAR_OR_MORE
     * @uses self::VALUE_THREE_STAR_OR_MORE
     * @uses self::VALUE_FOUR_STAR_OR_MORE
     * @uses self::VALUE_FIVE_STAR_OR_MORE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_ONE_STAR_OR_LESS,
            self::VALUE_TWO_STAR_OR_LESS,
            self::VALUE_THREE_STAR_OR_LESS,
            self::VALUE_FOUR_STAR_OR_LESS,
            self::VALUE_FIVE_STAR_OR_LESS,
            self::VALUE_ONE_STAR_OR_MORE,
            self::VALUE_TWO_STAR_OR_MORE,
            self::VALUE_THREE_STAR_OR_MORE,
            self::VALUE_FOUR_STAR_OR_MORE,
            self::VALUE_FIVE_STAR_OR_MORE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
