<?php

namespace EnumType;

/**
 * This class stands for HotelDetailsVerificationStatus EnumType
 * @subpackage Enumerations
 */
class HotelDetailsVerificationStatus
{
    /**
     * Constant for value 'Successful'
     * @return string 'Successful'
     */
    const VALUE_SUCCESSFUL = 'Successful';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Constant for value 'NotApplicable'
     * @return string 'NotApplicable'
     */
    const VALUE_NOT_APPLICABLE = 'NotApplicable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCESSFUL
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_NOT_APPLICABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCESSFUL,
            self::VALUE_FAILED,
            self::VALUE_NOT_APPLICABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
