<?php

namespace EnumType;

/**
 * This class stands for DateActionRes EnumType
 * @subpackage Enumerations
 */
class DateActionRes
{
    /**
     * Constant for value 'Retained'
     * @return string 'Retained'
     */
    const VALUE_RETAINED = 'Retained';
    /**
     * Constant for value 'Changed'
     * @return string 'Changed'
     */
    const VALUE_CHANGED = 'Changed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RETAINED
     * @uses self::VALUE_CHANGED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RETAINED,
            self::VALUE_CHANGED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
