<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSupplement ArrayType
 * @subpackage Arrays
 */
class ArrayOfSupplement extends AbstractStructArrayBase
{
    /**
     * The Supplement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Supplement[]
     */
    public $Supplement;
    /**
     * Constructor method for ArrayOfSupplement
     * @uses ArrayOfSupplement::setSupplement()
     * @param \StructType\Supplement[] $supplement
     */
    public function __construct(array $supplement = array())
    {
        $this
            ->setSupplement($supplement);
    }
    /**
     * Get Supplement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Supplement[]|null
     */
    public function getSupplement()
    {
        return isset($this->Supplement) ? $this->Supplement : null;
    }
    /**
     * Set Supplement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Supplement[] $supplement
     * @return \ArrayType\ArrayOfSupplement
     */
    public function setSupplement(array $supplement = array())
    {
        foreach ($supplement as $arrayOfSupplementSupplementItem) {
            // validation for constraint: itemType
            if (!$arrayOfSupplementSupplementItem instanceof \StructType\Supplement) {
                throw new \InvalidArgumentException(sprintf('The Supplement property can only contain items of \StructType\Supplement, "%s" given', is_object($arrayOfSupplementSupplementItem) ? get_class($arrayOfSupplementSupplementItem) : gettype($arrayOfSupplementSupplementItem)), __LINE__);
            }
        }
        if (is_null($supplement) || (is_array($supplement) && empty($supplement))) {
            unset($this->Supplement);
        } else {
            $this->Supplement = $supplement;
        }
        return $this;
    }
    /**
     * Add item to Supplement value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplement $item
     * @return \ArrayType\ArrayOfSupplement
     */
    public function addToSupplement(\StructType\Supplement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplement) {
            throw new \InvalidArgumentException(sprintf('The Supplement property can only contain items of \StructType\Supplement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Supplement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Supplement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Supplement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Supplement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Supplement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Supplement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Supplement
     */
    public function getAttributeName()
    {
        return 'Supplement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSupplement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
